/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.Captions;
import software.amazon.awssdk.services.elastictranscoder.model.Clip;
import software.amazon.awssdk.services.elastictranscoder.model.CompositionCopier;
import software.amazon.awssdk.services.elastictranscoder.model.Encryption;
import software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt;
import software.amazon.awssdk.services.elastictranscoder.model.JobWatermark;
import software.amazon.awssdk.services.elastictranscoder.model.JobWatermarksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobOutput> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(JobOutput.getter(JobOutput::id)).setter(JobOutput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(JobOutput.getter(JobOutput::key)).setter(JobOutput.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> THUMBNAIL_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThumbnailPattern").getter(JobOutput.getter(JobOutput::thumbnailPattern)).setter(JobOutput.setter(Builder::thumbnailPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailPattern").build()}).build();
    private static final SdkField<Encryption> THUMBNAIL_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThumbnailEncryption").getter(JobOutput.getter(JobOutput::thumbnailEncryption)).setter(JobOutput.setter(Builder::thumbnailEncryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailEncryption").build()}).build();
    private static final SdkField<String> ROTATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rotate").getter(JobOutput.getter(JobOutput::rotate)).setter(JobOutput.setter(Builder::rotate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rotate").build()}).build();
    private static final SdkField<String> PRESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PresetId").getter(JobOutput.getter(JobOutput::presetId)).setter(JobOutput.setter(Builder::presetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetId").build()}).build();
    private static final SdkField<String> SEGMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentDuration").getter(JobOutput.getter(JobOutput::segmentDuration)).setter(JobOutput.setter(Builder::segmentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDuration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(JobOutput.getter(JobOutput::status)).setter(JobOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetail").getter(JobOutput.getter(JobOutput::statusDetail)).setter(JobOutput.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(JobOutput.getter(JobOutput::duration)).setter(JobOutput.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(JobOutput.getter(JobOutput::width)).setter(JobOutput.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(JobOutput.getter(JobOutput::height)).setter(JobOutput.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameRate").getter(JobOutput.getter(JobOutput::frameRate)).setter(JobOutput.setter(Builder::frameRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()}).build();
    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileSize").getter(JobOutput.getter(JobOutput::fileSize)).setter(JobOutput.setter(Builder::fileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSize").build()}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMillis").getter(JobOutput.getter(JobOutput::durationMillis)).setter(JobOutput.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<List<JobWatermark>> WATERMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Watermarks").getter(JobOutput.getter(JobOutput::watermarks)).setter(JobOutput.setter(Builder::watermarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watermarks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobWatermark::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobAlbumArt> ALBUM_ART_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlbumArt").getter(JobOutput.getter(JobOutput::albumArt)).setter(JobOutput.setter(Builder::albumArt)).constructor(JobAlbumArt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlbumArt").build()}).build();
    private static final SdkField<List<Clip>> COMPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Composition").getter(JobOutput.getter(JobOutput::composition)).setter(JobOutput.setter(Builder::composition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Composition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Clip::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Captions> CAPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Captions").getter(JobOutput.getter(JobOutput::captions)).setter(JobOutput.setter(Builder::captions)).constructor(Captions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Captions").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(JobOutput.getter(JobOutput::encryption)).setter(JobOutput.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<String> APPLIED_COLOR_SPACE_CONVERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppliedColorSpaceConversion").getter(JobOutput.getter(JobOutput::appliedColorSpaceConversion)).setter(JobOutput.setter(Builder::appliedColorSpaceConversion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedColorSpaceConversion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, KEY_FIELD, THUMBNAIL_PATTERN_FIELD, THUMBNAIL_ENCRYPTION_FIELD, ROTATE_FIELD, PRESET_ID_FIELD, SEGMENT_DURATION_FIELD, STATUS_FIELD, STATUS_DETAIL_FIELD, DURATION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, FRAME_RATE_FIELD, FILE_SIZE_FIELD, DURATION_MILLIS_FIELD, WATERMARKS_FIELD, ALBUM_ART_FIELD, COMPOSITION_FIELD, CAPTIONS_FIELD, ENCRYPTION_FIELD, APPLIED_COLOR_SPACE_CONVERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String key;
    private final String thumbnailPattern;
    private final Encryption thumbnailEncryption;
    private final String rotate;
    private final String presetId;
    private final String segmentDuration;
    private final String status;
    private final String statusDetail;
    private final Long duration;
    private final Integer width;
    private final Integer height;
    private final String frameRate;
    private final Long fileSize;
    private final Long durationMillis;
    private final List<JobWatermark> watermarks;
    private final JobAlbumArt albumArt;
    private final List<Clip> composition;
    private final Captions captions;
    private final Encryption encryption;
    private final String appliedColorSpaceConversion;

    private JobOutput(BuilderImpl builder) {
        this.id = builder.id;
        this.key = builder.key;
        this.thumbnailPattern = builder.thumbnailPattern;
        this.thumbnailEncryption = builder.thumbnailEncryption;
        this.rotate = builder.rotate;
        this.presetId = builder.presetId;
        this.segmentDuration = builder.segmentDuration;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.duration = builder.duration;
        this.width = builder.width;
        this.height = builder.height;
        this.frameRate = builder.frameRate;
        this.fileSize = builder.fileSize;
        this.durationMillis = builder.durationMillis;
        this.watermarks = builder.watermarks;
        this.albumArt = builder.albumArt;
        this.composition = builder.composition;
        this.captions = builder.captions;
        this.encryption = builder.encryption;
        this.appliedColorSpaceConversion = builder.appliedColorSpaceConversion;
    }

    public final String id() {
        return this.id;
    }

    public final String key() {
        return this.key;
    }

    public final String thumbnailPattern() {
        return this.thumbnailPattern;
    }

    public final Encryption thumbnailEncryption() {
        return this.thumbnailEncryption;
    }

    public final String rotate() {
        return this.rotate;
    }

    public final String presetId() {
        return this.presetId;
    }

    public final String segmentDuration() {
        return this.segmentDuration;
    }

    public final String status() {
        return this.status;
    }

    public final String statusDetail() {
        return this.statusDetail;
    }

    public final Long duration() {
        return this.duration;
    }

    public final Integer width() {
        return this.width;
    }

    public final Integer height() {
        return this.height;
    }

    public final String frameRate() {
        return this.frameRate;
    }

    public final Long fileSize() {
        return this.fileSize;
    }

    public final Long durationMillis() {
        return this.durationMillis;
    }

    public final boolean hasWatermarks() {
        return this.watermarks != null && !(this.watermarks instanceof SdkAutoConstructList);
    }

    public final List<JobWatermark> watermarks() {
        return this.watermarks;
    }

    public final JobAlbumArt albumArt() {
        return this.albumArt;
    }

    public final boolean hasComposition() {
        return this.composition != null && !(this.composition instanceof SdkAutoConstructList);
    }

    public final List<Clip> composition() {
        return this.composition;
    }

    public final Captions captions() {
        return this.captions;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public final String appliedColorSpaceConversion() {
        return this.appliedColorSpaceConversion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotate());
        hashCode = 31 * hashCode + Objects.hashCode(this.presetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatermarks() ? this.watermarks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.albumArt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComposition() ? this.composition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.captions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedColorSpaceConversion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOutput)) {
            return false;
        }
        JobOutput other = (JobOutput)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.thumbnailPattern(), other.thumbnailPattern()) && Objects.equals(this.thumbnailEncryption(), other.thumbnailEncryption()) && Objects.equals(this.rotate(), other.rotate()) && Objects.equals(this.presetId(), other.presetId()) && Objects.equals(this.segmentDuration(), other.segmentDuration()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.fileSize(), other.fileSize()) && Objects.equals(this.durationMillis(), other.durationMillis()) && this.hasWatermarks() == other.hasWatermarks() && Objects.equals(this.watermarks(), other.watermarks()) && Objects.equals(this.albumArt(), other.albumArt()) && this.hasComposition() == other.hasComposition() && Objects.equals(this.composition(), other.composition()) && Objects.equals(this.captions(), other.captions()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.appliedColorSpaceConversion(), other.appliedColorSpaceConversion());
    }

    public final String toString() {
        return ToString.builder((String)"JobOutput").add("Id", (Object)this.id()).add("Key", (Object)this.key()).add("ThumbnailPattern", (Object)this.thumbnailPattern()).add("ThumbnailEncryption", (Object)this.thumbnailEncryption()).add("Rotate", (Object)this.rotate()).add("PresetId", (Object)this.presetId()).add("SegmentDuration", (Object)this.segmentDuration()).add("Status", (Object)this.status()).add("StatusDetail", (Object)this.statusDetail()).add("Duration", (Object)this.duration()).add("Width", (Object)this.width()).add("Height", (Object)this.height()).add("FrameRate", (Object)this.frameRate()).add("FileSize", (Object)this.fileSize()).add("DurationMillis", (Object)this.durationMillis()).add("Watermarks", this.hasWatermarks() ? this.watermarks() : null).add("AlbumArt", (Object)this.albumArt()).add("Composition", this.hasComposition() ? this.composition() : null).add("Captions", (Object)this.captions()).add("Encryption", (Object)this.encryption()).add("AppliedColorSpaceConversion", (Object)this.appliedColorSpaceConversion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "ThumbnailPattern": {
                return Optional.ofNullable(clazz.cast(this.thumbnailPattern()));
            }
            case "ThumbnailEncryption": {
                return Optional.ofNullable(clazz.cast(this.thumbnailEncryption()));
            }
            case "Rotate": {
                return Optional.ofNullable(clazz.cast(this.rotate()));
            }
            case "PresetId": {
                return Optional.ofNullable(clazz.cast(this.presetId()));
            }
            case "SegmentDuration": {
                return Optional.ofNullable(clazz.cast(this.segmentDuration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "FileSize": {
                return Optional.ofNullable(clazz.cast(this.fileSize()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "Watermarks": {
                return Optional.ofNullable(clazz.cast(this.watermarks()));
            }
            case "AlbumArt": {
                return Optional.ofNullable(clazz.cast(this.albumArt()));
            }
            case "Composition": {
                return Optional.ofNullable(clazz.cast(this.composition()));
            }
            case "Captions": {
                return Optional.ofNullable(clazz.cast(this.captions()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "AppliedColorSpaceConversion": {
                return Optional.ofNullable(clazz.cast(this.appliedColorSpaceConversion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobOutput, T> g) {
        return obj -> g.apply((JobOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String key;
        private String thumbnailPattern;
        private Encryption thumbnailEncryption;
        private String rotate;
        private String presetId;
        private String segmentDuration;
        private String status;
        private String statusDetail;
        private Long duration;
        private Integer width;
        private Integer height;
        private String frameRate;
        private Long fileSize;
        private Long durationMillis;
        private List<JobWatermark> watermarks = DefaultSdkAutoConstructList.getInstance();
        private JobAlbumArt albumArt;
        private List<Clip> composition = DefaultSdkAutoConstructList.getInstance();
        private Captions captions;
        private Encryption encryption;
        private String appliedColorSpaceConversion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOutput model) {
            this.id(model.id);
            this.key(model.key);
            this.thumbnailPattern(model.thumbnailPattern);
            this.thumbnailEncryption(model.thumbnailEncryption);
            this.rotate(model.rotate);
            this.presetId(model.presetId);
            this.segmentDuration(model.segmentDuration);
            this.status(model.status);
            this.statusDetail(model.statusDetail);
            this.duration(model.duration);
            this.width(model.width);
            this.height(model.height);
            this.frameRate(model.frameRate);
            this.fileSize(model.fileSize);
            this.durationMillis(model.durationMillis);
            this.watermarks(model.watermarks);
            this.albumArt(model.albumArt);
            this.composition(model.composition);
            this.captions(model.captions);
            this.encryption(model.encryption);
            this.appliedColorSpaceConversion(model.appliedColorSpaceConversion);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getThumbnailPattern() {
            return this.thumbnailPattern;
        }

        @Override
        public final Builder thumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
            return this;
        }

        public final void setThumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
        }

        public final Encryption.Builder getThumbnailEncryption() {
            return this.thumbnailEncryption != null ? this.thumbnailEncryption.toBuilder() : null;
        }

        @Override
        public final Builder thumbnailEncryption(Encryption thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption;
            return this;
        }

        public final void setThumbnailEncryption(Encryption.BuilderImpl thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption != null ? thumbnailEncryption.build() : null;
        }

        public final String getRotate() {
            return this.rotate;
        }

        @Override
        public final Builder rotate(String rotate) {
            this.rotate = rotate;
            return this;
        }

        public final void setRotate(String rotate) {
            this.rotate = rotate;
        }

        public final String getPresetId() {
            return this.presetId;
        }

        @Override
        public final Builder presetId(String presetId) {
            this.presetId = presetId;
            return this;
        }

        public final void setPresetId(String presetId) {
            this.presetId = presetId;
        }

        public final String getSegmentDuration() {
            return this.segmentDuration;
        }

        @Override
        public final Builder segmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
            return this;
        }

        public final void setSegmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Integer getWidth() {
            return this.width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public final Integer getHeight() {
            return this.height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final String getFrameRate() {
            return this.frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        public final Long getFileSize() {
            return this.fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        public final List<JobWatermark.Builder> getWatermarks() {
            List<JobWatermark.Builder> result = JobWatermarksCopier.copyToBuilder(this.watermarks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder watermarks(Collection<JobWatermark> watermarks) {
            this.watermarks = JobWatermarksCopier.copy(watermarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(JobWatermark ... watermarks) {
            this.watermarks(Arrays.asList(watermarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(Consumer<JobWatermark.Builder> ... watermarks) {
            this.watermarks(Stream.of(watermarks).map(c -> (JobWatermark)((JobWatermark.Builder)JobWatermark.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWatermarks(Collection<JobWatermark.BuilderImpl> watermarks) {
            this.watermarks = JobWatermarksCopier.copyFromBuilder(watermarks);
        }

        public final JobAlbumArt.Builder getAlbumArt() {
            return this.albumArt != null ? this.albumArt.toBuilder() : null;
        }

        @Override
        public final Builder albumArt(JobAlbumArt albumArt) {
            this.albumArt = albumArt;
            return this;
        }

        public final void setAlbumArt(JobAlbumArt.BuilderImpl albumArt) {
            this.albumArt = albumArt != null ? albumArt.build() : null;
        }

        public final List<Clip.Builder> getComposition() {
            List<Clip.Builder> result = CompositionCopier.copyToBuilder(this.composition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder composition(Collection<Clip> composition) {
            this.composition = CompositionCopier.copy(composition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder composition(Clip ... composition) {
            this.composition(Arrays.asList(composition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder composition(Consumer<Clip.Builder> ... composition) {
            this.composition(Stream.of(composition).map(c -> (Clip)((Clip.Builder)Clip.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComposition(Collection<Clip.BuilderImpl> composition) {
            this.composition = CompositionCopier.copyFromBuilder(composition);
        }

        public final Captions.Builder getCaptions() {
            return this.captions != null ? this.captions.toBuilder() : null;
        }

        @Override
        public final Builder captions(Captions captions) {
            this.captions = captions;
            return this;
        }

        public final void setCaptions(Captions.BuilderImpl captions) {
            this.captions = captions != null ? captions.build() : null;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getAppliedColorSpaceConversion() {
            return this.appliedColorSpaceConversion;
        }

        @Override
        public final Builder appliedColorSpaceConversion(String appliedColorSpaceConversion) {
            this.appliedColorSpaceConversion = appliedColorSpaceConversion;
            return this;
        }

        public final void setAppliedColorSpaceConversion(String appliedColorSpaceConversion) {
            this.appliedColorSpaceConversion = appliedColorSpaceConversion;
        }

        public JobOutput build() {
            return new JobOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobOutput> {
        public Builder id(String var1);

        public Builder key(String var1);

        public Builder thumbnailPattern(String var1);

        public Builder thumbnailEncryption(Encryption var1);

        default public Builder thumbnailEncryption(Consumer<Encryption.Builder> thumbnailEncryption) {
            return this.thumbnailEncryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(thumbnailEncryption)).build());
        }

        public Builder rotate(String var1);

        public Builder presetId(String var1);

        public Builder segmentDuration(String var1);

        public Builder status(String var1);

        public Builder statusDetail(String var1);

        public Builder duration(Long var1);

        public Builder width(Integer var1);

        public Builder height(Integer var1);

        public Builder frameRate(String var1);

        public Builder fileSize(Long var1);

        public Builder durationMillis(Long var1);

        public Builder watermarks(Collection<JobWatermark> var1);

        public Builder watermarks(JobWatermark ... var1);

        public Builder watermarks(Consumer<JobWatermark.Builder> ... var1);

        public Builder albumArt(JobAlbumArt var1);

        default public Builder albumArt(Consumer<JobAlbumArt.Builder> albumArt) {
            return this.albumArt((JobAlbumArt)((JobAlbumArt.Builder)JobAlbumArt.builder().applyMutation(albumArt)).build());
        }

        public Builder composition(Collection<Clip> var1);

        public Builder composition(Clip ... var1);

        public Builder composition(Consumer<Clip.Builder> ... var1);

        public Builder captions(Captions var1);

        default public Builder captions(Consumer<Captions.Builder> captions) {
            return this.captions((Captions)((Captions.Builder)Captions.builder().applyMutation(captions)).build());
        }

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder appliedColorSpaceConversion(String var1);
    }
}

