/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CompressionFormat {
    GZIP("GZIP"),
    LZ4("LZ4"),
    SNAPPY("SNAPPY"),
    BZIP2("BZIP2"),
    DEFLATE("DEFLATE"),
    LZO("LZO"),
    BROTLI("BROTLI"),
    ZSTD("ZSTD"),
    ZLIB("ZLIB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CompressionFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CompressionFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionFormat> knownValues() {
        return Stream.of(CompressionFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

