/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClient;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse;

public class ListEventTypesIterable
implements SdkIterable<ListEventTypesResponse> {
    private final CodestarNotificationsClient client;
    private final ListEventTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventTypesIterable(CodestarNotificationsClient client, ListEventTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventTypesResponseFetcher();
    }

    public Iterator<ListEventTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventTypeSummary> eventTypes() {
        Function<ListEventTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventTypes() != null) {
                return response.eventTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventTypesResponseFetcher
    implements SyncPageFetcher<ListEventTypesResponse> {
        private ListEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListEventTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventTypesResponse nextPage(ListEventTypesResponse previousPage) {
            if (previousPage == null) {
                return ListEventTypesIterable.this.client.listEventTypes(ListEventTypesIterable.this.firstRequest);
            }
            return ListEventTypesIterable.this.client.listEventTypes((ListEventTypesRequest)((Object)ListEventTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

