/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.BucketOwnerAccess;
import software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3LogsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3LogsConfig> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(S3LogsConfig.getter(S3LogsConfig::statusAsString)).setter(S3LogsConfig.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(S3LogsConfig.getter(S3LogsConfig::location)).setter(S3LogsConfig.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("encryptionDisabled").getter(S3LogsConfig.getter(S3LogsConfig::encryptionDisabled)).setter(S3LogsConfig.setter(Builder::encryptionDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build()}).build();
    private static final SdkField<String> BUCKET_OWNER_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketOwnerAccess").getter(S3LogsConfig.getter(S3LogsConfig::bucketOwnerAccessAsString)).setter(S3LogsConfig.setter(Builder::bucketOwnerAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwnerAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LOCATION_FIELD, ENCRYPTION_DISABLED_FIELD, BUCKET_OWNER_ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String location;
    private final Boolean encryptionDisabled;
    private final String bucketOwnerAccess;

    private S3LogsConfig(BuilderImpl builder) {
        this.status = builder.status;
        this.location = builder.location;
        this.encryptionDisabled = builder.encryptionDisabled;
        this.bucketOwnerAccess = builder.bucketOwnerAccess;
    }

    public final LogsConfigStatusType status() {
        return LogsConfigStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String location() {
        return this.location;
    }

    public final Boolean encryptionDisabled() {
        return this.encryptionDisabled;
    }

    public final BucketOwnerAccess bucketOwnerAccess() {
        return BucketOwnerAccess.fromValue(this.bucketOwnerAccess);
    }

    public final String bucketOwnerAccessAsString() {
        return this.bucketOwnerAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketOwnerAccessAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogsConfig)) {
            return false;
        }
        S3LogsConfig other = (S3LogsConfig)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.encryptionDisabled(), other.encryptionDisabled()) && Objects.equals(this.bucketOwnerAccessAsString(), other.bucketOwnerAccessAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3LogsConfig").add("Status", (Object)this.statusAsString()).add("Location", (Object)this.location()).add("EncryptionDisabled", (Object)this.encryptionDisabled()).add("BucketOwnerAccess", (Object)this.bucketOwnerAccessAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "encryptionDisabled": {
                return Optional.ofNullable(clazz.cast(this.encryptionDisabled()));
            }
            case "bucketOwnerAccess": {
                return Optional.ofNullable(clazz.cast(this.bucketOwnerAccessAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3LogsConfig, T> g) {
        return obj -> g.apply((S3LogsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String location;
        private Boolean encryptionDisabled;
        private String bucketOwnerAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogsConfig model) {
            this.status(model.status);
            this.location(model.location);
            this.encryptionDisabled(model.encryptionDisabled);
            this.bucketOwnerAccess(model.bucketOwnerAccess);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LogsConfigStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Boolean getEncryptionDisabled() {
            return this.encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        public final String getBucketOwnerAccess() {
            return this.bucketOwnerAccess;
        }

        @Override
        public final Builder bucketOwnerAccess(String bucketOwnerAccess) {
            this.bucketOwnerAccess = bucketOwnerAccess;
            return this;
        }

        @Override
        public final Builder bucketOwnerAccess(BucketOwnerAccess bucketOwnerAccess) {
            this.bucketOwnerAccess(bucketOwnerAccess == null ? null : bucketOwnerAccess.toString());
            return this;
        }

        public final void setBucketOwnerAccess(String bucketOwnerAccess) {
            this.bucketOwnerAccess = bucketOwnerAccess;
        }

        public S3LogsConfig build() {
            return new S3LogsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3LogsConfig> {
        public Builder status(String var1);

        public Builder status(LogsConfigStatusType var1);

        public Builder location(String var1);

        public Builder encryptionDisabled(Boolean var1);

        public Builder bucketOwnerAccess(String var1);

        public Builder bucketOwnerAccess(BucketOwnerAccess var1);
    }
}

