/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MessageAction {
    SUPPRESS("SUPPRESS"),
    RESEND("RESEND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MessageAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MessageAction.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageAction> knownValues() {
        return Stream.of(MessageAction.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

