/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExtendedKeyUsageType {
    SERVER_AUTH("SERVER_AUTH"),
    CLIENT_AUTH("CLIENT_AUTH"),
    CODE_SIGNING("CODE_SIGNING"),
    EMAIL_PROTECTION("EMAIL_PROTECTION"),
    TIME_STAMPING("TIME_STAMPING"),
    OCSP_SIGNING("OCSP_SIGNING"),
    SMART_CARD_LOGIN("SMART_CARD_LOGIN"),
    DOCUMENT_SIGNING("DOCUMENT_SIGNING"),
    CERTIFICATE_TRANSPARENCY("CERTIFICATE_TRANSPARENCY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExtendedKeyUsageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExtendedKeyUsageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExtendedKeyUsageType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExtendedKeyUsageType> knownValues() {
        return Stream.of(ExtendedKeyUsageType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

