/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import ru.yandex.qatools.allure.config.AllureResultsConfig;
import ru.yandex.qatools.allure.model.AttachmentType;

public final class AllureNamingUtils {
    public static final String FILE_NAME_PATTER = "%s-%s.%s";

    private AllureNamingUtils() {
    }

    public static String generateTestSuiteFileName(String name) {
        AllureResultsConfig config = AllureResultsConfig.newInstance();
        return String.format(FILE_NAME_PATTER, name, config.getTestSuiteFileSuffix(), config.getTestSuiteFileExtension());
    }

    public static String generateTestSuiteFileName() {
        return AllureNamingUtils.generateTestSuiteFileName(UUID.randomUUID().toString());
    }

    public static Collection<File> listTestSuiteFiles(File ... directory) {
        AllureResultsConfig config = AllureResultsConfig.newInstance();
        return AllureNamingUtils.listFiles(directory, (IOFileFilter)new RegexFileFilter(config.getTestSuiteFileRegex()), CanReadFileFilter.CAN_READ);
    }

    public static String generateAttachmentFileName(String name, AttachmentType type) {
        AllureResultsConfig config = AllureResultsConfig.newInstance();
        return String.format(FILE_NAME_PATTER, name, config.getAttachmentFileSuffix(), type.toString().toLowerCase());
    }

    public static String generateAttachmentFileName(AttachmentType type) {
        return AllureNamingUtils.generateAttachmentFileName(UUID.randomUUID().toString(), type);
    }

    public static Collection<File> listAttachmentFiles(File ... directories) {
        AllureResultsConfig config = AllureResultsConfig.newInstance();
        return AllureNamingUtils.listFiles(directories, (IOFileFilter)new RegexFileFilter(config.getAttachmentFileRegex()), CanReadFileFilter.CAN_READ);
    }

    public static Collection<File> listFiles(File[] directories, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        ArrayList<File> attachmentFiles = new ArrayList<File>();
        for (File directory : directories) {
            Collection attachmentsInDirectory = FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            attachmentFiles.addAll(attachmentsInDirectory);
        }
        return attachmentFiles;
    }
}

