/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Severity;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.SeverityLevel;

public class AnnotationManager {
    private Collection<Annotation> annotations;

    public AnnotationManager(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    public AnnotationManager(Annotation ... annotations) {
        this.annotations = Arrays.asList(annotations);
    }

    public void update(TestSuiteStartedEvent event) {
        if (this.isTitleAnnotationPresent()) {
            event.setTitle(this.getTitle());
        }
        if (this.isDescriptionAnnotationPresent()) {
            event.setDescription(this.getDescription());
        }
        if (this.isStoriesAnnotationPresent()) {
            event.getLabels().addAll(this.getStoryLabels());
        }
        if (this.isFeaturesAnnotationPresent()) {
            event.getLabels().addAll(this.getFeatureLabels());
        }
    }

    public void update(TestCaseStartedEvent event) {
        if (this.isTitleAnnotationPresent()) {
            event.setTitle(this.getTitle());
        }
        if (this.isDescriptionAnnotationPresent()) {
            event.setDescription(this.getDescription());
        }
        if (this.isStoriesAnnotationPresent()) {
            event.getLabels().addAll(this.getStoryLabels());
        }
        if (this.isFeaturesAnnotationPresent()) {
            event.getLabels().addAll(this.getFeatureLabels());
        }
        if (this.isSeverityAnnotationPresent()) {
            event.setSeverity(this.getSeverity());
        }
    }

    public boolean isTitleAnnotationPresent() {
        return this.isAnnotationPresent(Title.class);
    }

    public boolean isDescriptionAnnotationPresent() {
        return this.isAnnotationPresent(Description.class);
    }

    public boolean isSeverityAnnotationPresent() {
        return this.isAnnotationPresent(Severity.class);
    }

    public boolean isStoriesAnnotationPresent() {
        return this.isAnnotationPresent(Stories.class);
    }

    public boolean isFeaturesAnnotationPresent() {
        return this.isAnnotationPresent(Features.class);
    }

    public String getTitle() {
        return this.getAnnotation(Title.class).value();
    }

    public ru.yandex.qatools.allure.model.Description getDescription() {
        Description description = this.getAnnotation(Description.class);
        return new ru.yandex.qatools.allure.model.Description().withValue(description.value()).withType(description.type());
    }

    public SeverityLevel getSeverity() {
        return this.getAnnotation(Severity.class).value();
    }

    public List<Label> getStoryLabels() {
        ArrayList<Label> result = new ArrayList<Label>();
        for (String story : this.getAnnotation(Stories.class).value()) {
            result.add(new Label().withName("story").withValue(story));
        }
        return result;
    }

    public List<Label> getFeatureLabels() {
        ArrayList<Label> result = new ArrayList<Label>();
        for (String feature : this.getAnnotation(Features.class).value()) {
            result.add(new Label().withName("feature").withValue(feature));
        }
        return result;
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        for (Annotation each : this.annotations) {
            if (!each.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation each : this.annotations) {
            if (!each.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)annotationType.cast(each));
        }
        return null;
    }
}

