/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.utils;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import ru.yandex.qatools.allure.config.AllureNamingUtils;
import ru.yandex.qatools.allure.config.AllureResultsConfig;
import ru.yandex.qatools.allure.exceptions.AllureException;
import ru.yandex.qatools.allure.model.AttachmentType;
import ru.yandex.qatools.allure.model.ObjectFactory;
import ru.yandex.qatools.allure.model.TestSuiteResult;
import ru.yandex.qatools.allure.utils.XmlEscapeHandler;

public class AllureResultsUtils {
    private static File resultsDirectory;
    private static final Object LOCK;

    private AllureResultsUtils() {
    }

    public static File getResultsDirectory() {
        if (resultsDirectory == null) {
            resultsDirectory = AllureResultsUtils.createResultsDirectory();
        }
        return resultsDirectory;
    }

    public static File createResultsDirectory() {
        AllureResultsConfig resultsConfig = new AllureResultsConfig();
        File resultsDirectory = resultsConfig.getResultsDirectory();
        Object object = LOCK;
        synchronized (object) {
            if (resultsDirectory.exists() || resultsDirectory.mkdirs()) {
                return resultsDirectory;
            }
            throw new AllureException(String.format("Results directory <%s> doesn't exists or can't be created", resultsDirectory.getAbsolutePath()));
        }
    }

    public static void setResultsDirectory(File resultsDirectory) {
        AllureResultsUtils.resultsDirectory = resultsDirectory;
    }

    public static void writeTestSuiteResult(TestSuiteResult testSuiteResult) {
        File testSuiteResultFile = new File(AllureResultsUtils.getResultsDirectory(), AllureNamingUtils.generateTestSuiteFileName());
        try {
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{TestSuiteResult.class}).createMarshaller();
            m.setProperty(CharacterEscapeHandler.class.getName(), (Object)XmlEscapeHandler.getInstance());
            m.marshal((Object)new ObjectFactory().createTestSuite(testSuiteResult), testSuiteResultFile);
        }
        catch (JAXBException e) {
            throw new AllureException("Can't marshall test suite result", e);
        }
    }

    public static String writeAttachment(Object attachment, AttachmentType type) {
        String attachmentFileName = AllureNamingUtils.generateAttachmentFileName((AttachmentType)type);
        File attachmentFile = new File(AllureResultsUtils.getResultsDirectory(), attachmentFileName);
        AllureResultsUtils.writeAttachment(attachment, attachmentFile);
        return attachmentFileName;
    }

    public static void writeAttachment(Object content, File attachmentFile) {
        if (content instanceof String) {
            AllureResultsUtils.writeAttachment((String)content, attachmentFile);
        } else if (content instanceof File) {
            AllureResultsUtils.copyAttachment((File)content, attachmentFile);
        } else {
            throw new AllureException("Attach-method should be return 'java.lang.String' or 'java.io.File'.");
        }
    }

    public static void writeAttachment(String content, File attachmentFile) {
        try {
            FileUtils.writeStringToFile((File)attachmentFile, (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new AllureException("Can't write to file " + attachmentFile.getAbsolutePath(), e);
        }
    }

    public static void copyAttachment(File from, File to) {
        try {
            FileUtils.copyFile((File)from, (File)to);
        }
        catch (IOException e) {
            throw new AllureException("Can't copy attach file", e);
        }
    }

    static {
        LOCK = new Object();
    }
}

