/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure;

import ru.yandex.qatools.allure.events.ClearStepStorageEvent;
import ru.yandex.qatools.allure.events.ClearTestStorageEvent;
import ru.yandex.qatools.allure.events.StepEvent;
import ru.yandex.qatools.allure.events.StepFinishedEvent;
import ru.yandex.qatools.allure.events.StepStartedEvent;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.model.Step;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.allure.model.TestSuiteResult;
import ru.yandex.qatools.allure.storages.StepStorage;
import ru.yandex.qatools.allure.storages.TestCaseStorage;
import ru.yandex.qatools.allure.storages.TestSuiteStorage;
import ru.yandex.qatools.allure.utils.AllureResultsUtils;

public class Allure {
    public static final Allure LIFECYCLE = new Allure();
    private final StepStorage stepStorage = new StepStorage();
    private final TestCaseStorage testCaseStorage = new TestCaseStorage();
    private final TestSuiteStorage testSuiteStorage = new TestSuiteStorage();
    private final Object lock = new Object();

    private Allure() {
    }

    public void fire(StepStartedEvent event) {
        Step step = new Step();
        event.process(step);
        this.stepStorage.put(step);
    }

    public void fire(StepEvent event) {
        Step step = this.stepStorage.getLast();
        event.process(step);
    }

    public void fire(StepFinishedEvent event) {
        Step step = this.stepStorage.pollLast();
        event.process(step);
        this.stepStorage.getLast().getSteps().add(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(TestCaseStartedEvent event) {
        TestCaseResult testCase = (TestCaseResult)this.testCaseStorage.get();
        event.process(testCase);
        Object object = this.lock;
        synchronized (object) {
            this.testSuiteStorage.get(event.getSuiteUid()).getTestCases().add(testCase);
        }
    }

    public void fire(TestCaseEvent event) {
        TestCaseResult testCase = (TestCaseResult)this.testCaseStorage.get();
        event.process(testCase);
    }

    public void fire(TestCaseFinishedEvent event) {
        TestCaseResult testCase = (TestCaseResult)this.testCaseStorage.get();
        event.process(testCase);
        Step root = this.stepStorage.pollLast();
        testCase.getSteps().addAll(root.getSteps());
        testCase.getAttachments().addAll(root.getAttachments());
        this.stepStorage.remove();
        this.testCaseStorage.remove();
    }

    public void fire(TestSuiteEvent event) {
        TestSuiteResult testSuite = this.testSuiteStorage.get(event.getUid());
        event.process(testSuite);
    }

    public void fire(TestSuiteFinishedEvent event) {
        String suiteUid = event.getUid();
        TestSuiteResult testSuite = this.testSuiteStorage.get(suiteUid);
        event.process(testSuite);
        this.testSuiteStorage.remove(suiteUid);
        AllureResultsUtils.writeTestSuiteResult(testSuite);
    }

    public void fire(ClearStepStorageEvent event) {
        this.stepStorage.remove();
    }

    public void fire(ClearTestStorageEvent event) {
        this.testCaseStorage.remove();
    }

    public StepStorage getStepStorage() {
        return this.stepStorage;
    }

    public TestCaseStorage getTestCaseStorage() {
        return this.testCaseStorage;
    }

    public TestSuiteStorage getTestSuiteStorage() {
        return this.testSuiteStorage;
    }
}

