
package ru.yandex.qatools.allure.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.Label;


/**
 * <p>Java class for abstract-test-suite-started-event complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="abstract-test-suite-started-event">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;all>
 *         &lt;element name="uid" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="title" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="description" type="{urn:events.allure.qatools.yandex.ru}description"/>
 *         &lt;element name="labels" type="{urn:events.allure.qatools.yandex.ru}labels" minOccurs="0"/>
 *       &lt;/all>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "abstract-test-suite-started-event", propOrder = {

})
public abstract class AbstractTestSuiteStartedEvent implements Equals, HashCode, TestSuiteEvent
{

    @XmlElement(required = true)
    protected String uid;
    @XmlElement(required = true)
    protected String name;
    @XmlElement(required = true, nillable = true)
    protected String title;
    @XmlElement(required = true, nillable = true)
    protected Description description;
    @XmlElementWrapper(name = "labels")
    @XmlElement(name = "label")
    protected List<Label> labels;

    /**
     * Gets the value of the uid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUid() {
        return uid;
    }

    /**
     * Sets the value of the uid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUid(String value) {
        this.uid = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link Description }
     *     
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link Description }
     *     
     */
    public void setDescription(Description value) {
        this.description = value;
    }

    public List<Label> getLabels() {
        if (labels == null) {
            labels = new ArrayList<Label>();
        }
        return labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if (!(object instanceof AbstractTestSuiteStartedEvent)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final AbstractTestSuiteStartedEvent that = ((AbstractTestSuiteStartedEvent) object);
        {
            String lhsUid;
            lhsUid = this.getUid();
            String rhsUid;
            rhsUid = that.getUid();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "uid", lhsUid), LocatorUtils.property(thatLocator, "uid", rhsUid), lhsUid, rhsUid)) {
                return false;
            }
        }
        {
            String lhsName;
            lhsName = this.getName();
            String rhsName;
            rhsName = that.getName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "name", lhsName), LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName)) {
                return false;
            }
        }
        {
            String lhsTitle;
            lhsTitle = this.getTitle();
            String rhsTitle;
            rhsTitle = that.getTitle();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "title", lhsTitle), LocatorUtils.property(thatLocator, "title", rhsTitle), lhsTitle, rhsTitle)) {
                return false;
            }
        }
        {
            Description lhsDescription;
            lhsDescription = this.getDescription();
            Description rhsDescription;
            rhsDescription = that.getDescription();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "description", lhsDescription), LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription)) {
                return false;
            }
        }
        {
            List<Label> lhsLabels;
            lhsLabels = this.getLabels();
            List<Label> rhsLabels;
            rhsLabels = that.getLabels();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "labels", lhsLabels), LocatorUtils.property(thatLocator, "labels", rhsLabels), lhsLabels, rhsLabels)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theUid;
            theUid = this.getUid();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "uid", theUid), currentHashCode, theUid);
        }
        {
            String theName;
            theName = this.getName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "name", theName), currentHashCode, theName);
        }
        {
            String theTitle;
            theTitle = this.getTitle();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "title", theTitle), currentHashCode, theTitle);
        }
        {
            Description theDescription;
            theDescription = this.getDescription();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription);
        }
        {
            List<Label> theLabels;
            theLabels = this.getLabels();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "labels", theLabels), currentHashCode, theLabels);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public AbstractTestSuiteStartedEvent withUid(String value) {
        setUid(value);
        return this;
    }

    public AbstractTestSuiteStartedEvent withName(String value) {
        setName(value);
        return this;
    }

    public AbstractTestSuiteStartedEvent withTitle(String value) {
        setTitle(value);
        return this;
    }

    public AbstractTestSuiteStartedEvent withDescription(Description value) {
        setDescription(value);
        return this;
    }

    public AbstractTestSuiteStartedEvent withLabels(Label... values) {
        if (values!= null) {
            for (Label value: values) {
                getLabels().add(value);
            }
        }
        return this;
    }

    public AbstractTestSuiteStartedEvent withLabels(Collection<Label> values) {
        if (values!= null) {
            getLabels().addAll(values);
        }
        return this;
    }

    public AbstractTestSuiteStartedEvent withLabels(List<Label> labels) {
        setLabels(labels);
        return this;
    }

}
