/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseSQLTimestampParser
extends ClickHouseDateValueParser<Timestamp> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER_TZ = DateTimeFormatter.ofPattern("yyyy-MM-dd['T'][ ]HH:mm:ss[.SSS][XXX]");
    private static ClickHouseSQLTimestampParser instance;

    static ClickHouseSQLTimestampParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseSQLTimestampParser();
        }
        return instance;
    }

    private ClickHouseSQLTimestampParser() {
        super(Timestamp.class);
    }

    @Override
    Timestamp parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return Timestamp.from(this.dateToZonedDateTime(value, columnInfo, timeZone).toInstant());
    }

    @Override
    Timestamp parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return Timestamp.from(this.dateTimeToZonedDateTime(value, columnInfo, timeZone).toInstant());
    }

    @Override
    Timestamp parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return Timestamp.from(this.parseAsInstant(value));
    }

    @Override
    Timestamp parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return Timestamp.from(this.parseAsInstant(value));
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return Timestamp.from(this.parseAsLocalDateTime(value).atZone(this.effectiveTimeZone(columnInfo, timeZone)).toInstant());
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    return Timestamp.from(OffsetDateTime.parse(value, DATE_TIME_FORMATTER_TZ).toInstant());
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    return Timestamp.from(OffsetDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant());
                }
            }
        }
    }
}

