/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.zeromq.ZMQException;
import org.zeromq.ZeroMQ$;
import org.zeromq.ZeroMQLibrary;
import org.zeromq.zmq_free_fn;
import org.zeromq.zmq_msg_t;
import org.zeromq.zmq_pollitem_t;

public class ZMQ {
    private static final ZeroMQLibrary zmq = ZeroMQ$.MODULE$.loadLibrary();
    private static final int[] majorVersion = new int[1];
    private static final int[] minorVersion = new int[1];
    private static final int[] patchVersion = new int[1];
    public static final int NOBLOCK = ZeroMQ$.MODULE$.ZMQ_NOBLOCK();
    public static final int DONTWAIT = ZeroMQ$.MODULE$.ZMQ_NOBLOCK();
    public static final int PAIR = ZeroMQ$.MODULE$.ZMQ_PAIR();
    public static final int SNDMORE = ZeroMQ$.MODULE$.ZMQ_SNDMORE();
    public static final int PUB = ZeroMQ$.MODULE$.ZMQ_PUB();
    public static final int SUB = ZeroMQ$.MODULE$.ZMQ_SUB();
    public static final int REQ = ZeroMQ$.MODULE$.ZMQ_REQ();
    public static final int REP = ZeroMQ$.MODULE$.ZMQ_REP();
    public static final int XREQ = ZeroMQ$.MODULE$.ZMQ_DEALER();
    public static final int XREP = ZeroMQ$.MODULE$.ZMQ_ROUTER();
    public static final int DEALER = ZeroMQ$.MODULE$.ZMQ_DEALER();
    public static final int ROUTER = ZeroMQ$.MODULE$.ZMQ_ROUTER();
    public static final int PULL = ZeroMQ$.MODULE$.ZMQ_PULL();
    public static final int PUSH = ZeroMQ$.MODULE$.ZMQ_PUSH();
    public static final int STREAMER = ZeroMQ$.MODULE$.ZMQ_STREAMER();
    public static final int FORWARDER = ZeroMQ$.MODULE$.ZMQ_FORWARDER();
    public static final int QUEUE = ZeroMQ$.MODULE$.ZMQ_QUEUE();

    public static int getMajorVersion() {
        return majorVersion[0];
    }

    public static int getMinorVersion() {
        return minorVersion[0];
    }

    public static int getPatchVersion() {
        return patchVersion[0];
    }

    public static int getFullVersion() {
        return ZMQ.makeVersion(ZMQ.getMajorVersion(), ZMQ.getMinorVersion(), ZMQ.getPatchVersion());
    }

    public static int makeVersion(int n, int n2, int n3) {
        return n * 10000 + n2 * 100 + n3;
    }

    public static String getVersionString() {
        return String.format("%d.%d.%d", ZMQ.getMajorVersion(), ZMQ.getMinorVersion(), ZMQ.getPatchVersion());
    }

    public static Context context(int n) {
        return new Context(n);
    }

    static {
        zmq.zmq_version(majorVersion, minorVersion, patchVersion);
    }

    public static class Poller {
        public static final int POLLIN = ZeroMQ$.MODULE$.ZMQ_POLLIN();
        public static final int POLLOUT = ZeroMQ$.MODULE$.ZMQ_POLLOUT();
        public static final int POLLERR = ZeroMQ$.MODULE$.ZMQ_POLLERR();
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;
        private static final int UNINITIALIZED_TIMEOUT = -2;
        private long timeout = -2L;
        private int nextEventIndex = 0;
        private int maxEventCount = 0;
        private int curEventCount = 0;
        private Socket[] sockets = null;
        private short[] events = null;
        private short[] revents = null;
        private LinkedList<Integer> freeSlots = null;

        public int register(Socket socket) {
            return this.register(socket, POLLIN | POLLOUT | POLLERR);
        }

        public int register(Socket socket, int n) {
            int n2 = -1;
            if (!this.freeSlots.isEmpty()) {
                n2 = this.freeSlots.remove();
            } else {
                if (this.nextEventIndex >= this.maxEventCount) {
                    int n3 = this.maxEventCount + 16;
                    this.sockets = Arrays.copyOf(this.sockets, n3);
                    this.events = Arrays.copyOf(this.events, n3);
                    this.revents = Arrays.copyOf(this.revents, n3);
                    this.maxEventCount = n3;
                }
                n2 = this.nextEventIndex++;
            }
            this.sockets[n2] = socket;
            this.events[n2] = (short)n;
            ++this.curEventCount;
            return n2;
        }

        public void unregister(Socket socket) {
            for (int i = 0; i < this.nextEventIndex; ++i) {
                if (this.sockets[i] != socket) continue;
                this.unregisterSocketAtIndex(i);
                break;
            }
        }

        private void unregisterSocketAtIndex(int n) {
            this.sockets[n] = null;
            this.events[n] = 0;
            this.revents[n] = 0;
            this.freeSlots.add(n);
            --this.curEventCount;
        }

        public Socket getSocket(int n) {
            if (n < 0 || n >= this.nextEventIndex) {
                return null;
            }
            return this.sockets[n];
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long l) {
            this.timeout = l;
        }

        public int getSize() {
            return this.maxEventCount;
        }

        public int getNext() {
            return this.nextEventIndex;
        }

        public long poll() {
            long l = -1L;
            if (this.timeout != -2L) {
                l = this.timeout;
            }
            return this.poll(l);
        }

        public long poll(long l) {
            int n;
            int n2 = 0;
            for (int i = 0; i < this.nextEventIndex; ++i) {
                this.revents[i] = 0;
            }
            if (this.curEventCount == 0) {
                return 0L;
            }
            zmq_pollitem_t[] zmq_pollitem_tArray = (zmq_pollitem_t[])new zmq_pollitem_t().toArray(this.curEventCount);
            for (n = 0; n < n2; ++n) {
                zmq_pollitem_tArray[n] = new zmq_pollitem_t();
            }
            for (n = 0; n < this.sockets.length; ++n) {
                if (this.sockets[n] == null) continue;
                zmq_pollitem_tArray[n2].socket = this.sockets[n].ptr;
                zmq_pollitem_tArray[n2].fd = 0;
                zmq_pollitem_tArray[n2].events = this.events[n];
                zmq_pollitem_tArray[n2].revents = 0;
                ++n2;
            }
            if (n2 != this.curEventCount) {
                return 0L;
            }
            n2 = 0;
            n = zmq.zmq_poll(zmq_pollitem_tArray, this.curEventCount, new NativeLong(l));
            for (int i = 0; i < this.sockets.length; ++i) {
                if (this.sockets[i] == null) continue;
                this.revents[i] = zmq_pollitem_tArray[n2].revents;
                ++n2;
            }
            return n;
        }

        public boolean pollin(int n) {
            return this.poll_mask(n, POLLIN);
        }

        public boolean pollout(int n) {
            return this.poll_mask(n, POLLOUT);
        }

        public boolean pollerr(int n) {
            return this.poll_mask(n, POLLERR);
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        protected Poller(Context context, int n) {
            this.maxEventCount = n;
            this.sockets = new Socket[this.maxEventCount];
            this.events = new short[this.maxEventCount];
            this.revents = new short[this.maxEventCount];
            this.freeSlots = new LinkedList();
        }

        private boolean poll_mask(int n, int n2) {
            if (n2 <= 0 || n < 0 || n >= this.nextEventIndex) {
                return false;
            }
            return (this.revents[n] & n2) > 0;
        }
    }

    public static class Socket {
        protected Pointer ptr;
        MessageDataBuffer messageDataBuffer = new MessageDataBuffer();

        public void close() {
            zmq.zmq_close(this.ptr);
        }

        public int getType() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(2, 1, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_TYPE());
        }

        public long getLinger() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(2, 1, 0)) {
                return -1L;
            }
            return (int)this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_LINGER());
        }

        public long getReconnectIVL() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return (int)this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RECONNECT_IVL());
        }

        public long getBacklog() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return (int)this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_BACKLOG());
        }

        public long getReconnectIVLMax() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RECONNECT_IVL_MAX());
        }

        public long getMaxMsgSize() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_MAXMSGSIZE());
        }

        public long getSndHWM() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_SNDHWM());
        }

        public long getRcvHWM() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVHWM());
        }

        public long getHWM() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_HWM());
        }

        public long getSwap() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_SWAP());
        }

        public long getAffinity() {
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_AFFINITY());
        }

        public byte[] getIdentity() {
            return this.getBytesSockopt(ZeroMQ$.MODULE$.ZMQ_IDENTITY());
        }

        public long getRate() {
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RATE());
        }

        public long getRecoveryInterval() {
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RECOVERY_IVL());
        }

        public boolean hasMulticastLoop() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return false;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_MCAST_LOOP()) != 0L;
        }

        public void setMulticastHops(long l) {
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_MCAST_LOOP(), l);
        }

        public long getMulticastHops() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_MCAST_LOOP());
        }

        public void setReceiveTimeOut(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVTIMEO(), l);
        }

        public long getReceiveTimeOut() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVTIMEO());
        }

        public void setSendTimeOut(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_SNDTIMEO(), l);
        }

        public long getSendTimeOut() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_SNDTIMEO());
        }

        public long getSendBufferSize() {
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_SNDBUF());
        }

        public long getReceiveBufferSize() {
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVBUF());
        }

        public boolean hasReceiveMore() {
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVMORE()) != 0L;
        }

        public long getFD() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_FD());
        }

        public long getEvents() {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(ZeroMQ$.MODULE$.ZMQ_EVENTS());
        }

        public void setLinger(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(2, 1, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_LINGER(), l);
        }

        public void setReconnectIVL(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RECONNECT_IVL(), l);
        }

        public void setBacklog(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_BACKLOG(), l);
        }

        public void setReconnectIVLMax(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RECONNECT_IVL_MAX(), l);
        }

        public void setMaxMsgSize(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_MAXMSGSIZE(), l);
        }

        public void setSndHWM(long l) {
            if (ZMQ.getFullVersion() < ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_SNDHWM(), l);
        }

        public void setRcvHWM(long l) {
            if (ZMQ.getFullVersion() >= ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVHWM(), l);
        }

        public void setHWM(long l) {
            if (ZMQ.getFullVersion() >= ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_HWM(), l);
        }

        public void setSwap(long l) {
            if (ZMQ.getFullVersion() >= ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_SWAP(), l);
        }

        public void setAffinity(long l) {
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_AFFINITY(), l);
        }

        public void setIdentity(byte[] byArray) {
            this.setBytesSockopt(ZeroMQ$.MODULE$.ZMQ_IDENTITY(), byArray);
        }

        public void subscribe(byte[] byArray) {
            this.setBytesSockopt(ZeroMQ$.MODULE$.ZMQ_SUBSCRIBE(), byArray);
        }

        public void unsubscribe(byte[] byArray) {
            this.setBytesSockopt(ZeroMQ$.MODULE$.ZMQ_UNSUBSCRIBE(), byArray);
        }

        public void setRate(long l) {
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RATE(), l);
        }

        public void setRecoveryInterval(long l) {
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RECONNECT_IVL(), l);
        }

        public void setMulticastLoop(boolean bl) {
            if (ZMQ.getFullVersion() >= ZMQ.makeVersion(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_MCAST_LOOP(), bl ? 1L : 0L);
        }

        public void setSendBufferSize(long l) {
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_SNDBUF(), l);
        }

        public void setReceiveBufferSize(long l) {
            this.setLongSockopt(ZeroMQ$.MODULE$.ZMQ_RCVBUF(), l);
        }

        public void bind(String string) {
            zmq.zmq_bind(this.ptr, string);
        }

        public void connect(String string) {
            zmq.zmq_connect(this.ptr, string);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean send(byte[] byArray, int n) {
            zmq_msg_t zmq_msg_t2 = this.newZmqMessage(byArray);
            if (zmq.zmq_send(this.ptr, zmq_msg_t2, n) != 0) {
                if (zmq.zmq_errno() == ZeroMQ$.MODULE$.EAGAIN()) {
                    if (zmq.zmq_msg_close(zmq_msg_t2) == 0) return false;
                    this.raiseZMQException();
                } else {
                    zmq.zmq_msg_close(zmq_msg_t2);
                    this.raiseZMQException();
                    return false;
                }
            }
            if (zmq.zmq_msg_close(zmq_msg_t2) == 0) return true;
            this.raiseZMQException();
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public byte[] recv(int n) {
            zmq_msg_t zmq_msg_t2 = this.newZmqMessage();
            if (zmq.zmq_recv(this.ptr, zmq_msg_t2, n) != 0) {
                if (zmq.zmq_errno() == ZeroMQ$.MODULE$.EAGAIN()) {
                    if (zmq.zmq_msg_close(zmq_msg_t2) == 0) return null;
                    this.raiseZMQException();
                } else {
                    zmq.zmq_msg_close(zmq_msg_t2);
                    this.raiseZMQException();
                }
            }
            Pointer pointer = zmq.zmq_msg_data(zmq_msg_t2);
            int n2 = zmq.zmq_msg_size(zmq_msg_t2);
            byte[] byArray = pointer.getByteArray(0L, n2);
            if (zmq.zmq_msg_close(zmq_msg_t2) == 0) return byArray;
            this.raiseZMQException();
            return byArray;
        }

        protected Socket(Context context, int n) {
            this.ptr = zmq.zmq_socket(context.ptr, n);
        }

        protected void finalize() {
            this.close();
        }

        private long getLongSockopt(int n) {
            Memory memory = new Memory(8L);
            LongByReference longByReference = new LongByReference(8L);
            zmq.zmq_getsockopt(this.ptr, n, (Pointer)memory, longByReference);
            return memory.getLong(0L);
        }

        private void setLongSockopt(int n, long l) {
            NativeLong nativeLong = new NativeLong(8L);
            Memory memory = new Memory(8L);
            memory.setLong(0L, l);
            zmq.zmq_setsockopt(this.ptr, n, (Pointer)memory, nativeLong);
        }

        private byte[] getBytesSockopt(int n) {
            Memory memory = new Memory(1024L);
            LongByReference longByReference = new LongByReference(1024L);
            zmq.zmq_getsockopt(this.ptr, n, (Pointer)memory, longByReference);
            return memory.getByteArray(0L, (int)longByReference.getValue());
        }

        private void setBytesSockopt(int n, byte[] byArray) {
            NativeLong nativeLong = new NativeLong((long)byArray.length);
            Pointer pointer = null;
            if (byArray.length > 0) {
                pointer = new Memory((long)byArray.length);
                pointer.write(0L, byArray, 0, byArray.length);
            } else {
                pointer = Pointer.NULL;
            }
            zmq.zmq_setsockopt(this.ptr, n, pointer, nativeLong);
        }

        private zmq_msg_t newZmqMessage(byte[] byArray) {
            zmq_msg_t zmq_msg_t2 = new zmq_msg_t();
            if (byArray.length == 0) {
                if (zmq.zmq_msg_init_size(zmq_msg_t2, new NativeLong((long)byArray.length)) != 0) {
                    this.raiseZMQException();
                }
            } else {
                Memory memory = new Memory((long)byArray.length);
                memory.write(0L, byArray, 0, byArray.length);
                if (zmq.zmq_msg_init_data(zmq_msg_t2, (Pointer)memory, new NativeLong((long)byArray.length), this.messageDataBuffer, (Pointer)memory) == 0) {
                    this.messageDataBuffer.add((Pointer)memory);
                } else {
                    this.raiseZMQException();
                }
            }
            return zmq_msg_t2;
        }

        private zmq_msg_t newZmqMessage() {
            zmq_msg_t zmq_msg_t2 = new zmq_msg_t();
            if (zmq.zmq_msg_init(zmq_msg_t2) != 0) {
                this.raiseZMQException();
            }
            return zmq_msg_t2;
        }

        private void raiseZMQException() {
            int n = zmq.zmq_errno();
            String string = zmq.zmq_strerror(n);
            throw new ZMQException(string, n);
        }

        private class MessageDataBuffer
        implements zmq_free_fn {
            private HashSet<Pointer> buffer = new HashSet();

            private MessageDataBuffer() {
            }

            public synchronized void add(Pointer pointer) {
                this.buffer.add(pointer);
            }

            @Override
            public synchronized void invoke(Pointer pointer, Pointer pointer2) {
                this.buffer.remove(pointer2);
            }
        }
    }

    public static class Context {
        protected Pointer ptr;

        public void term() {
        }

        public Socket socket(int n) {
            return new Socket(this, n);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int n) {
            return new Poller(this, n);
        }

        protected Context(int n) {
            this.ptr = zmq.zmq_init(n);
        }
    }
}

