/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.matchers;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.w3c.dom.Node;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.xpath.JAXPXPathEngine;

public class EvaluateXPathMatcher
extends BaseMatcher<Object> {
    private final String xPath;
    private final Matcher<String> valueMatcher;
    private DocumentBuilderFactory dbf;
    private Map<String, String> prefix2Uri;

    public EvaluateXPathMatcher(String xPath, Matcher<String> valueMatcher) {
        this.xPath = xPath;
        this.valueMatcher = valueMatcher;
    }

    @Factory
    public static EvaluateXPathMatcher hasXPath(String xPath, Matcher<String> valueMatcher) {
        return new EvaluateXPathMatcher(xPath, valueMatcher);
    }

    public EvaluateXPathMatcher withDocumentBuilderFactory(DocumentBuilderFactory f) {
        this.dbf = f;
        return this;
    }

    public boolean matches(Object object) {
        String value = this.xPathEvaluate(object);
        return this.valueMatcher.matches((Object)value);
    }

    public void describeTo(Description description) {
        description.appendText("XML with XPath ").appendText(this.xPath);
        if (this.valueMatcher != null) {
            description.appendText(" evaluated to ").appendDescriptionOf(this.valueMatcher);
        }
    }

    public void describeMismatch(Object object, Description mismatchDescription) {
        if (this.valueMatcher != null) {
            String value = this.xPathEvaluate(object);
            this.valueMatcher.describeMismatch((Object)value, mismatchDescription);
        }
    }

    public EvaluateXPathMatcher withNamespaceContext(Map<String, String> prefix2Uri) {
        this.prefix2Uri = prefix2Uri;
        return this;
    }

    private String xPathEvaluate(Object input) {
        JAXPXPathEngine engine = new JAXPXPathEngine();
        if (this.prefix2Uri != null) {
            engine.setNamespaceContext(this.prefix2Uri);
        }
        Source s = Input.from((Object)input).build();
        Node n = this.dbf != null ? Convert.toNode((Source)s, (DocumentBuilderFactory)this.dbf) : Convert.toNode((Source)s);
        return engine.evaluate(this.xPath, n);
    }
}

