/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.cache;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.stat.IpStat;
import org.tio.core.stat.IpStatListener;

public class IpStatRemovalListener
implements RemovalListener {
    private static Logger log = LoggerFactory.getLogger(IpStatRemovalListener.class);
    private IpStatListener ipStatListener;
    private GroupContext groupContext = null;

    public IpStatRemovalListener(GroupContext groupContext, IpStatListener ipStatListener) {
        this.groupContext = groupContext;
        this.ipStatListener = ipStatListener;
    }

    public void onRemoval(Object key, Object value, RemovalCause cause) {
        IpStat ipStat = (IpStat)value;
        if (this.ipStatListener != null) {
            this.ipStatListener.onExpired(this.groupContext, ipStat);
        }
    }
}

