/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ReconnConf;
import org.tio.cluster.TioClusterConfig;
import org.tio.cluster.TioClusterVo;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.GroupContext;
import org.tio.core.PacketSendMode;
import org.tio.core.intf.Packet;
import org.tio.server.ServerGroupContext;
import org.tio.utils.convert.Converter;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.ReadLockHandler;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.page.Page;
import org.tio.utils.page.PageUtils;

public class Tio {
    private static Logger log = LoggerFactory.getLogger(Tio.class);

    public static void bindBsId(ChannelContext channelContext, String bsId) {
        channelContext.groupContext.bsIds.bind(channelContext, bsId);
    }

    public static void bindGroup(ChannelContext channelContext, String group) {
        channelContext.groupContext.groups.bind(group, channelContext);
    }

    public static void bindToken(ChannelContext channelContext, String token) {
        channelContext.groupContext.tokens.bind(token, channelContext);
    }

    public static void bindUser(ChannelContext channelContext, String userid) {
        channelContext.groupContext.users.bind(userid, channelContext);
    }

    public static Boolean bSend(ChannelContext channelContext, Packet packet) {
        if (channelContext == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        return Tio.send(channelContext, packet, countDownLatch, PacketSendMode.SINGLE_BLOCK);
    }

    public static Boolean bSend(GroupContext groupContext, String ip, int port, Packet packet) {
        return Tio.send(groupContext, ip, port, packet, true);
    }

    public static Boolean bSendToAll(GroupContext groupContext, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToAll(groupContext, packet, channelContextFilter, true);
    }

    public static Boolean bSendToBsId(GroupContext groupContext, String bsId, Packet packet) {
        return Tio.sendToBsId(groupContext, bsId, packet, true);
    }

    public static Boolean bSendToGroup(GroupContext groupContext, String group, Packet packet) {
        return Tio.bSendToGroup(groupContext, group, packet, null);
    }

    public static Boolean bSendToGroup(GroupContext groupContext, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToGroup(groupContext, group, packet, channelContextFilter, true);
    }

    public static Boolean bSendToId(GroupContext groupContext, String channelContextId, Packet packet) {
        return Tio.sendToId(groupContext, channelContextId, packet, true);
    }

    public static Boolean bSendToIp(GroupContext groupContext, String ip, Packet packet) {
        return Tio.bSendToIp(groupContext, ip, packet, null);
    }

    public static Boolean bSendToIp(GroupContext groupContext, String ip, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToIp(groupContext, ip, packet, channelContextFilter, true);
    }

    public static Boolean bSendToSet(GroupContext groupContext, SetWithLock<ChannelContext> setWithLock, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, true);
    }

    public static Boolean bSendToToken(GroupContext groupContext, String token, Packet packet) {
        return Tio.sendToToken(groupContext, token, packet, true);
    }

    public static Boolean bSendToUser(GroupContext groupContext, String userid, Packet packet) {
        return Tio.sendToUser(groupContext, userid, packet, true);
    }

    public static void close(ChannelContext channelContext, String remark) {
        Tio.close(channelContext, null, remark);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark) {
        Tio.close(channelContext, throwable, remark, false);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        Tio.close(channelContext, throwable, remark, isNeedRemove, true);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove, boolean needCloseLock) {
        if (channelContext == null) {
            return;
        }
        if (channelContext.isWaitingClose) {
            log.debug("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", (Object)channelContext);
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = null;
        if (needCloseLock) {
            writeLock = channelContext.closeLock.writeLock();
            boolean tryLock = writeLock.tryLock();
            if (!tryLock) {
                return;
            }
            channelContext.isWaitingClose = true;
            writeLock.unlock();
        } else {
            channelContext.isWaitingClose = true;
        }
        if (channelContext.asynchronousSocketChannel != null) {
            try {
                channelContext.asynchronousSocketChannel.shutdownInput();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
            try {
                channelContext.asynchronousSocketChannel.shutdownOutput();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
            try {
                channelContext.asynchronousSocketChannel.close();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
        }
        channelContext.closeMeta.setRemark(remark);
        channelContext.closeMeta.setThrowable(throwable);
        if (!isNeedRemove) {
            if (channelContext.isServer()) {
                isNeedRemove = true;
            } else {
                ClientChannelContext clientChannelContext = (ClientChannelContext)channelContext;
                if (!ReconnConf.isNeedReconn(clientChannelContext, false)) {
                    isNeedRemove = true;
                }
            }
        }
        channelContext.closeMeta.setNeedRemove(isNeedRemove);
        channelContext.groupContext.closeRunnable.addMsg((Object)channelContext);
        channelContext.groupContext.closeRunnable.execute();
    }

    public static void close(GroupContext groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = groupContext.clientNodes.find(clientIp, clientPort);
        Tio.close(channelContext, throwable, remark);
    }

    public static void closeGroup(GroupContext groupContext, String group, final String remark) {
        SetWithLock<ChannelContext> setWithLock = Tio.getChannelContextsByGroup(groupContext, group);
        setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

            public void handler(Set<ChannelContext> set) {
                for (ChannelContext channelContext : set) {
                    Tio.close(channelContext, remark);
                }
            }
        });
    }

    public static SetWithLock<ChannelContext> getAllChannelContexts(GroupContext groupContext) {
        return groupContext.connections;
    }

    public static SetWithLock<ChannelContext> getAllConnectedsChannelContexts(ClientGroupContext clientGroupContext) {
        return clientGroupContext.connecteds;
    }

    public static ChannelContext getChannelContextByBsId(GroupContext groupContext, String bsId) {
        return groupContext.bsIds.find(groupContext, bsId);
    }

    public static ChannelContext getChannelContextByClientNode(GroupContext groupContext, String clientIp, Integer clientPort) {
        return groupContext.clientNodes.find(clientIp, clientPort);
    }

    public static ChannelContext getChannelContextById(GroupContext groupContext, String channelContextId) {
        return groupContext.ids.find(groupContext, channelContextId);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByGroup(GroupContext groupContext, String group) {
        return groupContext.groups.clients(groupContext, group);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByToken(GroupContext groupContext, String token) {
        return groupContext.tokens.find(groupContext, token);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByUserid(GroupContext groupContext, String userid) {
        return groupContext.users.find(groupContext, userid);
    }

    public static Page<ChannelContext> getPageOfAll(GroupContext groupContext, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfAll(groupContext, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfAll(GroupContext groupContext, Integer pageIndex, Integer pageSize, Converter<T> converter) {
        SetWithLock<ChannelContext> setWithLock = Tio.getAllChannelContexts(groupContext);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize, converter);
    }

    public static Page<ChannelContext> getPageOfConnecteds(ClientGroupContext clientGroupContext, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfConnecteds(clientGroupContext, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfConnecteds(ClientGroupContext clientGroupContext, Integer pageIndex, Integer pageSize, Converter<T> converter) {
        SetWithLock<ChannelContext> setWithLock = Tio.getAllConnectedsChannelContexts(clientGroupContext);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize, converter);
    }

    public static Page<ChannelContext> getPageOfGroup(GroupContext groupContext, String group, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfGroup(groupContext, group, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfGroup(GroupContext groupContext, String group, Integer pageIndex, Integer pageSize, Converter<T> converter) {
        SetWithLock<ChannelContext> setWithLock = Tio.getChannelContextsByGroup(groupContext, group);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize, converter);
    }

    public static int groupCount(GroupContext groupContext, String group) {
        SetWithLock<ChannelContext> setWithLock = groupContext.groups.clients(groupContext, group);
        if (setWithLock == null) {
            return 0;
        }
        return ((Set)setWithLock.getObj()).size();
    }

    public static boolean isInGroup(String group, ChannelContext channelContext) {
        SetWithLock<String> set = channelContext.getGroups();
        if (set == null) {
            return false;
        }
        return ((Set)set.getObj()).contains(group);
    }

    public static void notifyClusterForBsId(GroupContext groupContext, String bsId, Packet packet) {
        TioClusterConfig tioClusterConfig = groupContext.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setBsId(bsId);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForGroup(GroupContext groupContext, String group, Packet packet) {
        TioClusterConfig tioClusterConfig = groupContext.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setGroup(group);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForId(GroupContext groupContext, String channelContextId, Packet packet) {
        TioClusterConfig tioClusterConfig = groupContext.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setChannelId(channelContextId);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForIp(GroupContext groupContext, String ip, Packet packet) {
        TioClusterConfig tioClusterConfig = groupContext.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setIp(ip);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForToken(GroupContext groupContext, String token, Packet packet) {
        TioClusterConfig tioClusterConfig = groupContext.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setToken(token);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForUser(GroupContext groupContext, String userid, Packet packet) {
        TioClusterConfig tioClusterConfig = groupContext.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setUserid(userid);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void remove(ChannelContext channelContext, String remark) {
        Tio.remove(channelContext, null, remark);
    }

    public static void remove(ChannelContext channelContext, Throwable throwable, String remark) {
        Tio.close(channelContext, throwable, remark, true);
    }

    public static void remove(GroupContext groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = groupContext.clientNodes.find(clientIp, clientPort);
        Tio.remove(channelContext, throwable, remark);
    }

    public static void remove(ServerGroupContext serverGroupContext, String ip, final String remark) {
        SetWithLock<ChannelContext> setWithLock = serverGroupContext.ips.clients(serverGroupContext, ip);
        if (setWithLock == null) {
            return;
        }
        setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

            public void handler(Set<ChannelContext> set) {
                for (ChannelContext channelContext : set) {
                    Tio.remove(channelContext, remark);
                }
            }
        });
    }

    public static Boolean send(ChannelContext channelContext, Packet packet) {
        return Tio.send(channelContext, packet, null, null);
    }

    private static Boolean send(ChannelContext channelContext, Packet packet, CountDownLatch countDownLatch, PacketSendMode packetSendMode) {
        try {
            if (packet == null || channelContext == null) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.isVirtual) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return true;
            }
            if (channelContext.isClosed || channelContext.isRemoved) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                if (channelContext != null) {
                    log.info("can't send data, {}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, channelContext.isClosed, channelContext.isRemoved});
                }
                return false;
            }
            boolean isSingleBlock = countDownLatch != null && packetSendMode == PacketSendMode.SINGLE_BLOCK;
            boolean isAdded = false;
            if (countDownLatch != null) {
                Packet.Meta meta = new Packet.Meta();
                meta.setCountDownLatch(countDownLatch);
                packet.setMeta(meta);
            }
            if (!(isAdded = channelContext.groupContext.useQueueSend ? channelContext.sendRunnable.addMsg(packet) : channelContext.sendRunnable.sendPacket(packet))) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.groupContext.useQueueSend) {
                channelContext.sendRunnable.execute();
            }
            if (isSingleBlock) {
                long timeout = 10L;
                try {
                    Boolean awaitFlag = countDownLatch.await(timeout, TimeUnit.SECONDS);
                    if (!awaitFlag.booleanValue()) {
                        log.error("{}, \u963b\u585e\u53d1\u9001\u8d85\u65f6, timeout:{}s, packet:{}", new Object[]{channelContext, timeout, packet.logstr()});
                    }
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
                Boolean isSentSuccess = packet.getMeta().getIsSentSuccess();
                return isSentSuccess;
            }
            return true;
        }
        catch (Throwable e) {
            log.error((Object)((Object)channelContext) + ", " + e.toString(), e);
            return false;
        }
    }

    public static Boolean send(GroupContext groupContext, String ip, int port, Packet packet) {
        return Tio.send(groupContext, ip, port, packet, false);
    }

    private static Boolean send(GroupContext groupContext, String ip, int port, Packet packet, boolean isBlock) {
        ChannelContext channelContext = groupContext.clientNodes.find(ip, port);
        if (channelContext != null) {
            if (isBlock) {
                return Tio.bSend(channelContext, packet);
            }
            return Tio.send(channelContext, packet);
        }
        log.info("{}, can find channelContext by {}:{}", new Object[]{groupContext.getName(), ip, port});
        return false;
    }

    public static void sendToAll(GroupContext groupContext, Packet packet) {
        Tio.sendToAll(groupContext, packet, null);
    }

    public static void sendToAll(GroupContext groupContext, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToAll(groupContext, packet, channelContextFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean sendToAll(GroupContext groupContext, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        try {
            Boolean ret;
            SetWithLock<ChannelContext> setWithLock = groupContext.connections;
            if (setWithLock == null) {
                log.debug("{}, \u6ca1\u6709\u4efb\u4f55\u8fde\u63a5", (Object)groupContext.getName());
                Boolean bl = false;
                return bl;
            }
            Boolean bl = ret = Tio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isBlock);
            return bl;
        }
        finally {
            TioClusterConfig tioClusterConfig;
            if (groupContext.isCluster() && !packet.isFromCluster() && (tioClusterConfig = groupContext.getTioClusterConfig()).isCluster4all()) {
                TioClusterVo tioClusterVo = new TioClusterVo(packet);
                tioClusterVo.setToAll(true);
                tioClusterConfig.publish(tioClusterVo);
            }
        }
    }

    public static Boolean sendToBsId(GroupContext groupContext, String bsId, Packet packet) {
        return Tio.sendToBsId(groupContext, bsId, packet, false);
    }

    private static Boolean sendToBsId(GroupContext groupContext, String bsId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Tio.getChannelContextByBsId(groupContext, bsId);
        if (channelContext == null) {
            TioClusterConfig tioClusterConfig;
            if (groupContext.isCluster() && !packet.isFromCluster() && (tioClusterConfig = groupContext.getTioClusterConfig()).isCluster4bsId()) {
                Tio.notifyClusterForBsId(groupContext, bsId, packet);
            }
            return false;
        }
        if (isBlock) {
            return Tio.bSend(channelContext, packet);
        }
        return Tio.send(channelContext, packet);
    }

    public static void sendToGroup(GroupContext groupContext, String group, Packet packet) {
        Tio.sendToGroup(groupContext, group, packet, null);
    }

    public static void sendToGroup(GroupContext groupContext, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToGroup(groupContext, group, packet, channelContextFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean sendToGroup(GroupContext groupContext, String group, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        try {
            Boolean ret;
            SetWithLock<ChannelContext> setWithLock = groupContext.groups.clients(groupContext, group);
            if (setWithLock == null) {
                log.debug("{}, \u7ec4[{}]\u4e0d\u5b58\u5728", (Object)groupContext.getName(), (Object)group);
                Boolean bl = false;
                return bl;
            }
            Boolean bl = ret = Tio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isBlock);
            return bl;
        }
        finally {
            TioClusterConfig tioClusterConfig;
            if (groupContext.isCluster() && !packet.isFromCluster() && (tioClusterConfig = groupContext.getTioClusterConfig()).isCluster4group()) {
                Tio.notifyClusterForGroup(groupContext, group, packet);
            }
        }
    }

    public static Boolean sendToId(GroupContext groupContext, String channelContextId, Packet packet) {
        return Tio.sendToId(groupContext, channelContextId, packet, false);
    }

    private static Boolean sendToId(GroupContext groupContext, String channelContextId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Tio.getChannelContextById(groupContext, channelContextId);
        if (channelContext == null) {
            TioClusterConfig tioClusterConfig;
            if (groupContext.isCluster() && !packet.isFromCluster() && (tioClusterConfig = groupContext.getTioClusterConfig()).isCluster4channelId()) {
                Tio.notifyClusterForId(groupContext, channelContextId, packet);
            }
            return false;
        }
        if (isBlock) {
            return Tio.bSend(channelContext, packet);
        }
        return Tio.send(channelContext, packet);
    }

    public static void sendToIp(GroupContext groupContext, String ip, Packet packet) {
        Tio.sendToIp(groupContext, ip, packet, null);
    }

    public static void sendToIp(GroupContext groupContext, String ip, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToIp(groupContext, ip, packet, channelContextFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean sendToIp(GroupContext groupContext, String ip, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        try {
            Boolean ret;
            SetWithLock<ChannelContext> setWithLock = groupContext.ips.clients(groupContext, ip);
            if (setWithLock == null) {
                log.info("{}, \u6ca1\u6709ip\u4e3a[{}]\u7684\u5bf9\u7aef", (Object)groupContext.getName(), (Object)ip);
                Boolean bl = false;
                return bl;
            }
            Boolean bl = ret = Tio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isBlock);
            return bl;
        }
        finally {
            TioClusterConfig tioClusterConfig;
            if (groupContext.isCluster() && !packet.isFromCluster() && (tioClusterConfig = groupContext.getTioClusterConfig()).isCluster4ip()) {
                Tio.notifyClusterForIp(groupContext, ip, packet);
            }
        }
    }

    public static void sendToSet(GroupContext groupContext, SetWithLock<ChannelContext> setWithLock, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToSet(GroupContext groupContext, SetWithLock<ChannelContext> setWithLock, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 9[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean sendToToken(GroupContext groupContext, String token, Packet packet) {
        return Tio.sendToToken(groupContext, token, packet, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToToken(GroupContext groupContext, String token, Packet packet, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean sendToUser(GroupContext groupContext, String userid, Packet packet) {
        return Tio.sendToUser(groupContext, userid, packet, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToUser(GroupContext groupContext, String userid, Packet packet, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Packet synSend(ChannelContext channelContext, Packet packet, long timeout) {
        Integer synSeq = packet.getSynSeq();
        if (synSeq == null || synSeq <= 0) {
            throw new RuntimeException("synSeq\u5fc5\u987b\u5927\u4e8e0");
        }
        MapWithLock<Integer, Packet> waitingResps = channelContext.groupContext.getWaitingResps();
        try {
            waitingResps.put((Object)synSeq, (Object)packet);
            Packet packet2 = packet;
            synchronized (packet2) {
                Tio.send(channelContext, packet);
                try {
                    packet.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            Packet respPacket = (Packet)waitingResps.remove((Object)synSeq);
            if (respPacket == null) {
                log.error("respPacket == null,{}", (Object)channelContext);
                return null;
            }
            if (respPacket == packet) {
                log.error("{}, \u540c\u6b65\u53d1\u9001\u8d85\u65f6, {}", (Object)channelContext.groupContext.getName(), (Object)channelContext);
                return null;
            }
            return respPacket;
        }
    }

    public static void unbindBsId(ChannelContext channelContext) {
        channelContext.groupContext.bsIds.unbind(channelContext);
    }

    public static void unbindGroup(ChannelContext channelContext) {
        channelContext.groupContext.groups.unbind(channelContext);
    }

    public static void unbindGroup(String group, ChannelContext channelContext) {
        channelContext.groupContext.groups.unbind(group, channelContext);
    }

    public static void unbindToken(ChannelContext channelContext) {
        channelContext.groupContext.tokens.unbind(channelContext);
    }

    public static void unbindToken(GroupContext groupContext, String token) {
        groupContext.tokens.unbind(groupContext, token);
    }

    public static void unbindUser(ChannelContext channelContext) {
        channelContext.groupContext.users.unbind(channelContext);
    }

    public static void unbindUser(GroupContext groupContext, String userid) {
        groupContext.users.unbind(groupContext, userid);
    }

    private Tio() {
    }

    public static class IpBlacklist {
        public static boolean add(GroupContext groupContext, String ip) {
            return groupContext.ipBlacklist.add(ip);
        }

        public static void clear(GroupContext groupContext) {
            groupContext.ipBlacklist.clear();
        }

        public static Collection<String> getAll(GroupContext groupContext) {
            return groupContext.ipBlacklist.getAll();
        }

        public static boolean isInBlacklist(GroupContext groupContext, String ip) {
            return groupContext.ipBlacklist.isInBlacklist(ip);
        }

        public static void remove(GroupContext groupContext, String ip) {
            groupContext.ipBlacklist.remove(ip);
        }
    }
}

