/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.Tio;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.IpStat;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.task.SendRunnable;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.prop.MapWithLockPropSupport;

public abstract class ChannelContext
extends MapWithLockPropSupport {
    private static Logger log = LoggerFactory.getLogger(ChannelContext.class);
    private static final String DEFAULT_ATTUBITE_KEY = "t-io-d-a-k";
    public static final String UNKNOWN_ADDRESS_IP = "$UNKNOWN";
    public static final AtomicInteger UNKNOWN_ADDRESS_PORT_SEQ = new AtomicInteger();
    public boolean isReconnect = false;
    public boolean logWhenDecodeError = false;
    public Long heartbeatTimeout = null;
    public Integer packetNeededLength = null;
    public GroupContext groupContext = null;
    public DecodeRunnable decodeRunnable = null;
    public HandlerRunnable handlerRunnable = null;
    public SendRunnable sendRunnable = null;
    public final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private ReadCompletionHandler readCompletionHandler = null;
    public WriteCompletionHandler writeCompletionHandler = null;
    public SslFacadeContext sslFacadeContext;
    public String userid;
    private String token;
    private String bsId;
    public boolean isWaitingClose = false;
    public boolean isClosed = true;
    public boolean isRemoved = false;
    public boolean isVirtual = false;
    public boolean hasTempDir = false;
    public final ChannelStat stat = new ChannelStat();
    public AsynchronousSocketChannel asynchronousSocketChannel;
    private String id = null;
    private Node clientNode;
    private Node serverNode;
    private SetWithLock<String> groups = null;
    public CloseMeta closeMeta = new CloseMeta();

    public ChannelContext(GroupContext groupContext, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.init(groupContext, asynchronousSocketChannel);
        if (groupContext.sslConfig != null) {
            try {
                SslFacadeContext sslFacadeContext = new SslFacadeContext(this);
                if (groupContext.isServer()) {
                    sslFacadeContext.beginHandshake();
                }
            }
            catch (Exception e) {
                log.error("\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Tio.close(this, "\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38" + e.getMessage());
                return;
            }
        }
    }

    public ChannelContext(GroupContext groupContext) {
        Node clientNode;
        this.isVirtual = true;
        this.groupContext = groupContext;
        this.clientNode = clientNode = new Node("127.0.0.1", 26254);
        this.id = groupContext.getTioUuid().uuid();
    }

    private void assignAnUnknownClientNode() {
        Node clientNode = new Node(UNKNOWN_ADDRESS_IP, UNKNOWN_ADDRESS_PORT_SEQ.incrementAndGet());
        this.setClientNode(clientNode);
    }

    public abstract Node createClientNode(AsynchronousSocketChannel var1) throws IOException;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChannelContext other = (ChannelContext)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Object getAttribute() {
        return this.getAttribute(DEFAULT_ATTUBITE_KEY);
    }

    public Object get() {
        return this.getAttribute();
    }

    public Node getClientNode() {
        return this.clientNode;
    }

    public SetWithLock<String> getGroups() {
        return this.groups;
    }

    public String getId() {
        return this.id;
    }

    public ReadCompletionHandler getReadCompletionHandler() {
        return this.readCompletionHandler;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public String getToken() {
        return this.token;
    }

    public WriteCompletionHandler getWriteCompletionHandler() {
        return this.writeCompletionHandler;
    }

    public int hashCode() {
        if (StrUtil.isNotBlank((CharSequence)this.id)) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public void init(GroupContext groupContext, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.id = groupContext.getTioUuid().uuid();
        this.setGroupContext(groupContext);
        groupContext.ids.bind(this);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel);
        this.readCompletionHandler = new ReadCompletionHandler(this);
        this.writeCompletionHandler = new WriteCompletionHandler(this);
        this.logWhenDecodeError = groupContext.logWhenDecodeError;
    }

    public void processAfterSent(Packet packet, Boolean isSentSuccess) {
        block14: {
            isSentSuccess = isSentSuccess == null ? false : isSentSuccess;
            Packet.Meta meta = packet.getMeta();
            if (meta != null) {
                CountDownLatch countDownLatch = meta.getCountDownLatch();
                countDownLatch.countDown();
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("{} \u5df2\u7ecf\u53d1\u9001 {}", (Object)this, (Object)packet.logstr());
                }
                if (this.sslFacadeContext != null && !this.sslFacadeContext.isHandshakeCompleted()) break block14;
                if (this.groupContext.getAioListener() != null) {
                    try {
                        this.groupContext.getAioListener().onAfterSent(this, packet, isSentSuccess);
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
                if (this.groupContext.statOn) {
                    this.groupContext.groupStat.sentPackets.incrementAndGet();
                    this.stat.sentPackets.incrementAndGet();
                }
                if (this.groupContext.ipStats.durationList == null || this.groupContext.ipStats.durationList.size() <= 0) break block14;
                try {
                    for (Long v : this.groupContext.ipStats.durationList) {
                        IpStat ipStat = this.groupContext.ipStats.get(v, this.getClientNode().getIp());
                        ipStat.getSentPackets().incrementAndGet();
                        this.groupContext.getIpStatListener().onAfterSent(this, packet, isSentSuccess, ipStat);
                    }
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
        if (packet.getPacketListener() != null) {
            try {
                packet.getPacketListener().onAfterSent(this, packet, isSentSuccess);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    public void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        if (asynchronousSocketChannel != null) {
            try {
                Node clientNode = this.createClientNode(asynchronousSocketChannel);
                this.setClientNode(clientNode);
            }
            catch (IOException e) {
                log.info(e.toString(), (Throwable)e);
                this.assignAnUnknownClientNode();
            }
        } else {
            this.assignAnUnknownClientNode();
        }
    }

    public void setAttribute(Object value) {
        this.setAttribute(DEFAULT_ATTUBITE_KEY, value);
    }

    public void set(Object value) {
        this.setAttribute(value);
    }

    public void setClientNode(Node clientNode) {
        if (!this.groupContext.isShortConnection && this.clientNode != null) {
            this.groupContext.clientNodes.remove(this);
        }
        this.clientNode = clientNode;
        if (this.groupContext.isShortConnection) {
            return;
        }
        if (this.clientNode != null && !Objects.equals(UNKNOWN_ADDRESS_IP, this.clientNode.getIp())) {
            this.groupContext.clientNodes.put(this);
        }
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
        if (isClosed && (this.clientNode == null || !UNKNOWN_ADDRESS_IP.equals(this.clientNode.getIp()))) {
            String before = this.toString();
            this.assignAnUnknownClientNode();
            log.info("\u5173\u95ed\u524d{}, \u5173\u95ed\u540e{}", (Object)before, (Object)this);
        }
    }

    public void setGroupContext(GroupContext groupContext) {
        this.groupContext = groupContext;
        if (groupContext != null) {
            this.decodeRunnable = new DecodeRunnable(this, (Executor)groupContext.tioExecutor);
            this.handlerRunnable = new HandlerRunnable(this, (Executor)groupContext.tioExecutor);
            this.sendRunnable = new SendRunnable(this, (Executor)groupContext.tioExecutor);
            groupContext.connections.add((Object)this);
        }
    }

    public void setGroups(SetWithLock<String> groups) {
        this.groups = groups;
    }

    public void setPacketNeededLength(Integer packetNeededLength) {
        this.packetNeededLength = packetNeededLength;
    }

    public void setReconnect(boolean isReconnect) {
        this.isReconnect = isReconnect;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setServerNode(Node serverNode) {
        this.serverNode = serverNode;
    }

    public void setSslFacadeContext(SslFacadeContext sslFacadeContext) {
        this.sslFacadeContext = sslFacadeContext;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        if (this.serverNode != null) {
            sb.append("server:").append(this.serverNode.toString());
        } else {
            sb.append("server:").append("NULL");
        }
        if (this.clientNode != null) {
            sb.append(", client:").append(this.clientNode.toString());
        } else {
            sb.append(", client:").append("NULL");
        }
        if (this.isVirtual) {
            sb.append(", virtual");
        }
        return sb.toString();
    }

    public String getBsId() {
        return this.bsId;
    }

    public void setBsId(String bsId) {
        this.bsId = bsId;
    }

    public GroupContext getGroupContext() {
        return this.groupContext;
    }

    public abstract boolean isServer();

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public static class CloseMeta {
        public Throwable throwable;
        public String remark;
        public boolean isNeedRemove;

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public boolean isNeedRemove() {
            return this.isNeedRemove;
        }

        public void setNeedRemove(boolean isNeedRemove) {
            this.isNeedRemove = isNeedRemove;
        }
    }
}

