/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MockRestRequestMatchers {
    public static RequestMatcher anything() {
        return request -> {};
    }

    public static RequestMatcher method(HttpMethod method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        return request -> AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
    }

    public static RequestMatcher requestTo(Matcher<? super String> matcher) {
        Assert.notNull(matcher, (String)"'matcher' must not be null");
        return request -> MatcherAssert.assertThat((String)"Request URI", (Object)request.getURI().toString(), (Matcher)matcher);
    }

    public static RequestMatcher requestTo(String expectedUri) {
        Assert.notNull((Object)expectedUri, (String)"'uri' must not be null");
        return request -> AssertionErrors.assertEquals("Request URI", expectedUri, request.getURI().toString());
    }

    public static RequestMatcher requestToUriTemplate(String expectedUri, Object ... uriVars) {
        Assert.notNull((Object)expectedUri, (String)"'uri' must not be null");
        URI uri = UriComponentsBuilder.fromUriString((String)expectedUri).buildAndExpand(uriVars).encode().toUri();
        return MockRestRequestMatchers.requestTo(uri);
    }

    public static RequestMatcher requestTo(URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return request -> AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
    }

    public static RequestMatcher queryParamList(String name, Matcher<? super List<String>> matcher) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            List paramValues = (List)params.get((Object)name);
            if (paramValues == null) {
                AssertionErrors.fail("Expected query param <" + name + "> to exist but was null");
            }
            MatcherAssert.assertThat((String)("Query param [" + name + "] values"), (Object)paramValues, (Matcher)matcher);
        };
    }

    @SafeVarargs
    public static RequestMatcher queryParam(String name, Matcher<? super String> ... matchers) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            MockRestRequestMatchers.assertValueCount(name, params, matchers.length);
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat((String)"Query param", (Object)((String)((List)params.get((Object)name)).get(i)), (Matcher)matchers[i]);
            }
        };
    }

    public static RequestMatcher queryParam(String name, String ... expectedValues) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            MockRestRequestMatchers.assertValueCount(name, params, expectedValues.length);
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Query param [" + name + "]", expectedValues[i], ((List)params.get((Object)name)).get(i));
            }
        };
    }

    private static MultiValueMap<String, String> getQueryParams(ClientHttpRequest request) {
        return UriComponentsBuilder.fromUri((URI)request.getURI()).build().getQueryParams();
    }

    public static RequestMatcher headerList(String name, Matcher<? super List<String>> matcher) {
        return request -> {
            List headerValues = request.getHeaders().get(name);
            if (headerValues == null) {
                AssertionErrors.fail("Expected header <" + name + "> to exist but was null");
            }
            MatcherAssert.assertThat((String)("Request header [" + name + "] values"), (Object)headerValues, (Matcher)matcher);
        };
    }

    @SafeVarargs
    public static RequestMatcher header(String name, Matcher<? super String> ... matchers) {
        return request -> {
            MockRestRequestMatchers.assertValueCount(name, request.getHeaders(), matchers.length);
            List headerValues = request.getHeaders().get(name);
            Assert.state((headerValues != null ? 1 : 0) != 0, (String)"No header values");
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat((String)("Request header [" + name + "]"), (Object)((String)headerValues.get(i)), (Matcher)matchers[i]);
            }
        };
    }

    public static RequestMatcher header(String name, String ... expectedValues) {
        return request -> {
            MockRestRequestMatchers.assertValueCount(name, request.getHeaders(), expectedValues.length);
            List headerValues = request.getHeaders().get(name);
            Assert.state((headerValues != null ? 1 : 0) != 0, (String)"No header values");
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Request header [" + name + "]", expectedValues[i], headerValues.get(i));
            }
        };
    }

    public static RequestMatcher headerDoesNotExist(String name) {
        return request -> {
            List headerValues = request.getHeaders().get(name);
            if (headerValues != null) {
                AssertionErrors.fail("Expected header <" + name + "> not to exist, but it exists with values: " + String.valueOf(headerValues));
            }
        };
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<? super T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }

    private static void assertValueCount(String name, MultiValueMap<String, String> map, int count) {
        List values = (List)map.get((Object)name);
        String message = "Expected query param <" + name + ">";
        if (values == null) {
            AssertionErrors.fail(message + " to exist but was null");
        } else if (count > values.size()) {
            AssertionErrors.fail(message + " to have at least <" + count + "> values but found " + String.valueOf(values));
        }
    }

    private static void assertValueCount(String name, HttpHeaders headers, int count) {
        List values = headers.get(name);
        String message = "Expected header <" + name + ">";
        if (values == null) {
            AssertionErrors.fail(message + " to exist but was null");
        } else if (count > values.size()) {
            AssertionErrors.fail(message + " to have at least <" + count + "> values but found " + String.valueOf(values));
        }
    }
}

