/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.When;
import org.springframework.lang.Nullable;

public class CaseExpression
extends AbstractSegment
implements Expression {
    private final List<When> whenList;
    @Nullable
    private final Expression elseExpression;

    private static Segment[] children(List<When> whenList, @Nullable Expression elseExpression) {
        ArrayList<When> segments = new ArrayList<When>(whenList);
        if (elseExpression != null) {
            segments.add((When)((Object)elseExpression));
        }
        return segments.toArray(new Segment[0]);
    }

    private CaseExpression(List<When> whenList, @Nullable Expression elseExpression) {
        super(CaseExpression.children(whenList, elseExpression));
        this.whenList = whenList;
        this.elseExpression = elseExpression;
    }

    public static CaseExpression create(When condition) {
        return new CaseExpression(List.of(condition), null);
    }

    public CaseExpression when(When condition) {
        ArrayList<When> conditions = new ArrayList<When>(this.whenList);
        conditions.add(condition);
        return new CaseExpression(conditions, this.elseExpression);
    }

    public CaseExpression elseExpression(Expression elseExpression) {
        return new CaseExpression(this.whenList, elseExpression);
    }

    @Override
    public String toString() {
        return "CASE " + this.whenList.stream().map(When::toString).collect(Collectors.joining(" ")) + (String)(this.elseExpression != null ? " ELSE " + this.elseExpression : "") + " END";
    }
}

