/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.GraphParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class GraphQueryMethod
extends QueryMethod {
    private final Method method;
    private final Query queryAnnotation;
    private final Integer queryDepthParamIndex;
    private final boolean isExistsQuery;
    @Nullable
    private MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext;

    public GraphQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.queryAnnotation = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class);
        this.isExistsQuery = this.queryAnnotation != null ? this.queryAnnotation.exists() : false;
        this.queryDepthParamIndex = this.getQueryDepthParamIndex(method);
        Integer queryDepth = this.getStaticQueryDepth(method);
        if (queryDepth != null && this.queryDepthParamIndex != null) {
            throw new IllegalArgumentException(method.getName() + " cannot have both a method @Depth and a parameter @Depth");
        }
    }

    protected Parameters<?, ?> createParameters(Method method) {
        return new GraphParameters(method);
    }

    public GraphParameters getParameters() {
        return (GraphParameters)super.getParameters();
    }

    public MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setMappingContext(MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public String getQuery() {
        return this.queryAnnotation.value();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getNamedQueryName() {
        return String.format("%s.%s", this.getDomainClass().getSimpleName(), this.method.getName());
    }

    public String getNamedCountQueryName() {
        return String.format("%s.countQuery", this.getNamedQueryName());
    }

    public Integer getQueryDepthParamIndex() {
        return this.queryDepthParamIndex;
    }

    private Integer getQueryDepthParamIndex(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].length <= 0) continue;
            for (Annotation annotation : annotations[i]) {
                if (annotation.annotationType() != Depth.class) continue;
                if (method.getParameterTypes()[i] == Integer.class || method.getParameterTypes()[i] == Integer.TYPE) {
                    return i;
                }
                throw new IllegalArgumentException("Depth parameter in " + method.getName() + " must be an integer");
            }
        }
        return null;
    }

    private Integer getStaticQueryDepth(Method method) {
        if (method.isAnnotationPresent(Depth.class)) {
            return method.getAnnotation(Depth.class).value();
        }
        return null;
    }

    public String getCountQueryString() {
        return this.queryAnnotation != null ? this.queryAnnotation.countQuery() : null;
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    boolean isAnnotatedExistsQuery() {
        return this.isExistsQuery;
    }

    private String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    private Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }
}

