/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.AggregationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;

public class ReactiveStringBasedAggregation
extends AbstractReactiveMongoQuery {
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final ReactiveMongoOperations reactiveMongoOperations;
    private final MongoConverter mongoConverter;

    public ReactiveStringBasedAggregation(ReactiveMongoQueryMethod method, ReactiveMongoOperations reactiveMongoOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, reactiveMongoOperations, expressionParser, evaluationContextProvider);
        this.reactiveMongoOperations = reactiveMongoOperations;
        this.mongoConverter = reactiveMongoOperations.getConverter();
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    protected Object doExecute(ReactiveMongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, Class<?> typeToRead) {
        Class<?> sourceType = method.getDomainClass();
        Class<Object> targetType = typeToRead;
        List<AggregationOperation> pipeline = this.computePipeline(accessor);
        AggregationUtils.appendSortIfPresent(pipeline, accessor, typeToRead);
        AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor);
        boolean isSimpleReturnType = this.isSimpleReturnType(typeToRead);
        boolean isRawReturnType = ClassUtils.isAssignable(Document.class, typeToRead);
        if (isSimpleReturnType || isRawReturnType) {
            targetType = Document.class;
        }
        AggregationOptions options = this.computeOptions(method, accessor);
        TypedAggregation aggregation = new TypedAggregation(sourceType, pipeline, options);
        Flux flux = this.reactiveMongoOperations.aggregate(aggregation, targetType);
        if (isSimpleReturnType && !isRawReturnType) {
            flux = flux.map(it -> AggregationUtils.extractSimpleTypeResult((Document)it, typeToRead, this.mongoConverter));
        }
        if (method.isCollectionQuery()) {
            return flux;
        }
        return flux.next();
    }

    private boolean isSimpleReturnType(Class<?> targetType) {
        return MongoSimpleTypes.HOLDER.isSimpleType(targetType);
    }

    List<AggregationOperation> computePipeline(ConvertingParameterAccessor accessor) {
        return AggregationUtils.computePipeline(this.getQueryMethod(), accessor, this.expressionParser, this.evaluationContextProvider);
    }

    private AggregationOptions computeOptions(MongoQueryMethod method, ConvertingParameterAccessor accessor) {
        AggregationOptions.Builder builder = Aggregation.newAggregationOptions();
        AggregationUtils.applyCollation(builder, method.getAnnotatedCollation(), accessor, method.getParameters(), this.expressionParser, this.evaluationContextProvider);
        AggregationUtils.applyMeta(builder, method);
        return builder.build();
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        throw new UnsupportedOperationException("No query support for aggregation");
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected boolean isDeleteQuery() {
        return false;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

