/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import javax.validation.constraints.Min;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.cloud.stream.binder.rabbit.RabbitCommonProperties;

public class RabbitProducerProperties
extends RabbitCommonProperties {
    private String prefix = "";
    private String[] requestHeaderPatterns = new String[]{"STANDARD_REQUEST_HEADERS", "*"};
    private boolean autoBindDlq;
    private boolean compress;
    private boolean batchingEnabled;
    private int batchSize = 100;
    private int batchBufferLimit = 10000;
    private int batchTimeout = 5000;
    private boolean transacted;
    private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;
    private String[] replyHeaderPatterns = new String[]{"STANDARD_REPLY_HEADERS", "*"};
    private String delayExpression;
    private String routingKeyExpression;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRequestHeaderPatterns(String[] requestHeaderPatterns) {
        this.requestHeaderPatterns = requestHeaderPatterns;
    }

    public String[] getRequestHeaderPatterns() {
        return this.requestHeaderPatterns;
    }

    public void setAutoBindDlq(boolean autoBindDlq) {
        this.autoBindDlq = autoBindDlq;
    }

    public boolean isAutoBindDlq() {
        return this.autoBindDlq;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setDeliveryMode(MessageDeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public String[] getReplyHeaderPatterns() {
        return this.replyHeaderPatterns;
    }

    public void setReplyHeaderPatterns(String[] replyHeaderPatterns) {
        this.replyHeaderPatterns = replyHeaderPatterns;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    @Min(value=1L, message="Batch Size should be greater than zero.")
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Min(value=1L, message="Batch Buffer Limit should be greater than zero.")
    public int getBatchBufferLimit() {
        return this.batchBufferLimit;
    }

    public void setBatchBufferLimit(int batchBufferLimit) {
        this.batchBufferLimit = batchBufferLimit;
    }

    @Min(value=1L, message="Batch Timeout should be greater than zero.")
    public int getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(int batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public String getDelayExpression() {
        return this.delayExpression;
    }

    public void setDelayExpression(String delayExpression) {
        this.delayExpression = delayExpression;
    }

    public String getRoutingKeyExpression() {
        return this.routingKeyExpression;
    }

    public void setRoutingKeyExpression(String routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }
}

