/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.heroku;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.AbstractCloudConnector;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.FallbackServiceInfoCreator;
import org.springframework.cloud.ServiceInfoCreator;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.heroku.ApplicationInstanceInfoCreator;
import org.springframework.cloud.heroku.HerokuServiceInfoCreator;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.FallbackBaseServiceInfoCreator;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceData;
import org.springframework.cloud.util.EnvironmentAccessor;

public class HerokuConnector
extends AbstractCloudConnector<UriBasedServiceData> {
    private EnvironmentAccessor environment = new EnvironmentAccessor();
    private ApplicationInstanceInfoCreator applicationInstanceInfoCreator = new ApplicationInstanceInfoCreator(this.environment);
    private List<String> serviceEnvPrefixes;

    public HerokuConnector() {
        super(HerokuServiceInfoCreator.class);
    }

    public boolean isInMatchingCloud() {
        return this.environment.getEnvValue("DYNO") != null;
    }

    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        try {
            return this.applicationInstanceInfoCreator.createApplicationInstanceInfo();
        }
        catch (Exception e) {
            throw new CloudException((Throwable)e);
        }
    }

    void setCloudEnvironment(EnvironmentAccessor environment) {
        this.environment = environment;
        this.applicationInstanceInfoCreator = new ApplicationInstanceInfoCreator(environment);
    }

    protected void registerServiceInfoCreator(ServiceInfoCreator<? extends ServiceInfo, UriBasedServiceData> serviceInfoCreator) {
        super.registerServiceInfoCreator(serviceInfoCreator);
        HerokuServiceInfoCreator herokuServiceInfoCreator = (HerokuServiceInfoCreator)serviceInfoCreator;
        String[] envPrefixes = herokuServiceInfoCreator.getEnvPrefixes();
        if (this.serviceEnvPrefixes == null) {
            this.serviceEnvPrefixes = new ArrayList<String>();
        }
        this.serviceEnvPrefixes.addAll(Arrays.asList(envPrefixes));
    }

    protected List<UriBasedServiceData> getServicesData() {
        ArrayList<UriBasedServiceData> serviceData = new ArrayList<UriBasedServiceData>();
        Map env = this.environment.getEnv();
        for (Map.Entry envEntry : env.entrySet()) {
            for (String envPrefix : this.serviceEnvPrefixes) {
                if (!((String)envEntry.getKey()).startsWith(envPrefix)) continue;
                serviceData.add(new UriBasedServiceData((String)envEntry.getKey(), (String)envEntry.getValue()));
            }
        }
        return serviceData;
    }

    protected FallbackServiceInfoCreator<BaseServiceInfo, UriBasedServiceData> getFallbackServiceInfoCreator() {
        return new FallbackBaseServiceInfoCreator();
    }
}

