/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.springframework.boot.buildpack.platform.docker.UpdateEvent;

public class LogUpdateEvent
extends UpdateEvent {
    private static final Pattern ANSI_PATTERN = Pattern.compile("\u001b\\[[;\\d]*m");
    private static final Pattern TRAILING_NEW_LINE_PATTERN = Pattern.compile("\\n$");
    private final StreamType streamType;
    private final byte[] payload;
    private final String string;

    LogUpdateEvent(StreamType streamType, byte[] payload) {
        this.streamType = streamType;
        this.payload = payload;
        String string = new String(payload, StandardCharsets.UTF_8);
        string = ANSI_PATTERN.matcher(string).replaceAll("");
        this.string = string = TRAILING_NEW_LINE_PATTERN.matcher(string).replaceAll("");
    }

    public void print() {
        switch (this.streamType) {
            case STD_OUT: {
                System.out.println(this);
                return;
            }
            case STD_ERR: {
                System.err.println(this);
                return;
            }
        }
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String toString() {
        return this.string;
    }

    static void readAll(InputStream inputStream, Consumer<LogUpdateEvent> consumer) throws IOException {
        try {
            LogUpdateEvent event;
            while ((event = LogUpdateEvent.read(inputStream)) != null) {
                consumer.accept(event);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static LogUpdateEvent read(InputStream inputStream) throws IOException {
        byte[] header = LogUpdateEvent.read(inputStream, 8L);
        if (header == null) {
            return null;
        }
        StreamType streamType = StreamType.values()[header[0]];
        long size = 0L;
        for (int i = 0; i < 4; ++i) {
            size = (size << 8) + (long)(header[i + 4] & 0xFF);
        }
        byte[] payload = LogUpdateEvent.read(inputStream, size);
        return new LogUpdateEvent(streamType, payload);
    }

    private static byte[] read(InputStream inputStream, long size) throws IOException {
        int amountRead;
        byte[] data = new byte[(int)size];
        int offset = 0;
        do {
            if ((amountRead = inputStream.read(data, offset, data.length - offset)) != -1) continue;
            return null;
        } while ((offset += amountRead) < data.length);
        return data;
    }

    public static enum StreamType {
        STD_IN,
        STD_OUT,
        STD_ERR;

    }
}

