/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigureprocessor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.boot.autoconfigureprocessor.Elements;

@SupportedAnnotationTypes(value={"org.springframework.context.annotation.Configuration", "org.springframework.boot.autoconfigure.condition.ConditionalOnClass", "org.springframework.boot.autoconfigure.condition.ConditionalOnBean", "org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate", "org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication", "org.springframework.boot.autoconfigure.AutoConfigureBefore", "org.springframework.boot.autoconfigure.AutoConfigureAfter", "org.springframework.boot.autoconfigure.AutoConfigureOrder"})
public class AutoConfigureAnnotationProcessor
extends AbstractProcessor {
    protected static final String PROPERTIES_PATH = "META-INF/spring-autoconfigure-metadata.properties";
    private final Map<String, String> annotations;
    private final Map<String, ValueExtractor> valueExtractors;
    private final Properties properties = new Properties();

    public AutoConfigureAnnotationProcessor() {
        LinkedHashMap<String, String> annotations = new LinkedHashMap<String, String>();
        this.addAnnotations(annotations);
        this.annotations = Collections.unmodifiableMap(annotations);
        LinkedHashMap<String, ValueExtractor> valueExtractors = new LinkedHashMap<String, ValueExtractor>();
        this.addValueExtractors(valueExtractors);
        this.valueExtractors = Collections.unmodifiableMap(valueExtractors);
    }

    protected void addAnnotations(Map<String, String> annotations) {
        annotations.put("Configuration", "org.springframework.context.annotation.Configuration");
        annotations.put("ConditionalOnClass", "org.springframework.boot.autoconfigure.condition.ConditionalOnClass");
        annotations.put("ConditionalOnBean", "org.springframework.boot.autoconfigure.condition.ConditionalOnBean");
        annotations.put("ConditionalOnSingleCandidate", "org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate");
        annotations.put("ConditionalOnWebApplication", "org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication");
        annotations.put("AutoConfigureBefore", "org.springframework.boot.autoconfigure.AutoConfigureBefore");
        annotations.put("AutoConfigureAfter", "org.springframework.boot.autoconfigure.AutoConfigureAfter");
        annotations.put("AutoConfigureOrder", "org.springframework.boot.autoconfigure.AutoConfigureOrder");
    }

    private void addValueExtractors(Map<String, ValueExtractor> attributes) {
        attributes.put("Configuration", ValueExtractor.allFrom("value"));
        attributes.put("ConditionalOnClass", new OnClassConditionValueExtractor());
        attributes.put("ConditionalOnBean", new OnBeanConditionValueExtractor());
        attributes.put("ConditionalOnSingleCandidate", new OnBeanConditionValueExtractor());
        attributes.put("ConditionalOnWebApplication", ValueExtractor.allFrom("type"));
        attributes.put("AutoConfigureBefore", ValueExtractor.allFrom("value", "name"));
        attributes.put("AutoConfigureAfter", ValueExtractor.allFrom("value", "name"));
        attributes.put("AutoConfigureOrder", ValueExtractor.allFrom("value"));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Map.Entry<String, String> entry : this.annotations.entrySet()) {
            this.process(roundEnv, entry.getKey(), entry.getValue());
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeProperties();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to write metadata", ex);
            }
        }
        return false;
    }

    private void process(RoundEnvironment roundEnv, String propertyKey, String annotationName) {
        TypeElement annotationType = this.processingEnv.getElementUtils().getTypeElement(annotationName);
        if (annotationType != null) {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                Element enclosingElement = element.getEnclosingElement();
                if (enclosingElement == null || enclosingElement.getKind() != ElementKind.PACKAGE) continue;
                this.processElement(element, propertyKey, annotationName);
            }
        }
    }

    private void processElement(Element element, String propertyKey, String annotationName) {
        try {
            String qualifiedName = Elements.getQualifiedName(element);
            AnnotationMirror annotation = this.getAnnotation(element, annotationName);
            if (qualifiedName != null && annotation != null) {
                List<Object> values = this.getValues(propertyKey, annotation);
                this.properties.put(qualifiedName + "." + propertyKey, this.toCommaDelimitedString(values));
                this.properties.put(qualifiedName, "");
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + element, ex);
        }
    }

    private AnnotationMirror getAnnotation(Element element, String type) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private String toCommaDelimitedString(List<Object> list) {
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append(result.length() != 0 ? "," : "");
            result.append(item);
        }
        return result.toString();
    }

    private List<Object> getValues(String propertyKey, AnnotationMirror annotation) {
        ValueExtractor extractor = this.valueExtractors.get(propertyKey);
        if (extractor == null) {
            return Collections.emptyList();
        }
        return extractor.getValues(annotation);
    }

    private void writeProperties() throws IOException {
        if (!this.properties.isEmpty()) {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", PROPERTIES_PATH, new Element[0]);
            try (OutputStream outputStream = file.openOutputStream();){
                this.properties.store(outputStream, null);
            }
        }
    }

    private static class OnClassConditionValueExtractor
    extends NamedValuesExtractor {
        OnClassConditionValueExtractor() {
            super("value", "name");
        }

        @Override
        public List<Object> getValues(AnnotationMirror annotation) {
            List<Object> values = super.getValues(annotation);
            Collections.sort(values, this::compare);
            return values;
        }

        private int compare(Object o1, Object o2) {
            return Comparator.comparing(this::isSpringClass).thenComparing(String.CASE_INSENSITIVE_ORDER).compare(o1.toString(), o2.toString());
        }

        private boolean isSpringClass(String type) {
            return type.startsWith("org.springframework");
        }
    }

    private static class OnBeanConditionValueExtractor
    extends AbstractValueExtractor {
        private OnBeanConditionValueExtractor() {
        }

        @Override
        public List<Object> getValues(AnnotationMirror annotation) {
            LinkedHashMap attributes = new LinkedHashMap();
            annotation.getElementValues().forEach((key, value) -> attributes.put(key.getSimpleName().toString(), value));
            if (attributes.containsKey("name")) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            this.extractValues((AnnotationValue)attributes.get("value")).forEach(result::add);
            this.extractValues((AnnotationValue)attributes.get("type")).forEach(result::add);
            return result;
        }
    }

    private static class NamedValuesExtractor
    extends AbstractValueExtractor {
        private final Set<String> names;

        NamedValuesExtractor(String ... names) {
            this.names = new HashSet<String>(Arrays.asList(names));
        }

        @Override
        public List<Object> getValues(AnnotationMirror annotation) {
            ArrayList<Object> result = new ArrayList<Object>();
            annotation.getElementValues().forEach((key, value) -> {
                if (this.names.contains(key.getSimpleName().toString())) {
                    this.extractValues((AnnotationValue)value).forEach(result::add);
                }
            });
            return result;
        }
    }

    private static abstract class AbstractValueExtractor
    implements ValueExtractor {
        private AbstractValueExtractor() {
        }

        protected Stream<Object> extractValues(AnnotationValue annotationValue) {
            if (annotationValue == null) {
                return Stream.empty();
            }
            Object value = annotationValue.getValue();
            if (value instanceof List) {
                return ((List)value).stream().map(annotation -> this.extractValue(annotation.getValue()));
            }
            return Stream.of(this.extractValue(value));
        }

        private Object extractValue(Object value) {
            if (value instanceof DeclaredType) {
                return Elements.getQualifiedName(((DeclaredType)value).asElement());
            }
            return value;
        }
    }

    @FunctionalInterface
    private static interface ValueExtractor {
        public List<Object> getValues(AnnotationMirror var1);

        public static ValueExtractor allFrom(String ... names) {
            return new NamedValuesExtractor(names);
        }
    }
}

