/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;

public final class WebFluxTags {
    private WebFluxTags() {
    }

    public static Tag method(ServerWebExchange exchange) {
        return Tag.of((String)"method", (String)exchange.getRequest().getMethod().toString());
    }

    public static Tag status(ServerWebExchange exchange) {
        HttpStatus status = exchange.getResponse().getStatusCode();
        if (status == null) {
            status = HttpStatus.OK;
        }
        return Tag.of((String)"status", (String)status.toString());
    }

    public static Tag uri(ServerWebExchange exchange) {
        String uri;
        PathPattern pathPattern = (PathPattern)exchange.getAttributeOrDefault(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE, null);
        String string = uri = pathPattern == null ? exchange.getRequest().getURI().toString() : pathPattern.getPatternString();
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        return Tag.of((String)"uri", (String)(uri.isEmpty() ? "root" : uri));
    }

    public static Tag exception(Throwable exception) {
        if (exception != null) {
            return Tag.of((String)"exception", (String)exception.getClass().getSimpleName());
        }
        return Tag.of((String)"exception", (String)"none");
    }
}

