/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import java.util.function.BiConsumer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.ExposableJmxEndpoint;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class DefaultEndpointObjectNameFactory
implements EndpointObjectNameFactory {
    private final JmxEndpointProperties properties;
    private final MBeanServer mBeanServer;
    private final String contextId;

    DefaultEndpointObjectNameFactory(JmxEndpointProperties properties, MBeanServer mBeanServer, String contextId) {
        this.properties = properties;
        this.mBeanServer = mBeanServer;
        this.contextId = contextId;
    }

    public ObjectName getObjectName(ExposableJmxEndpoint endpoint) throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder(this.properties.getDomain());
        builder.append(":type=Endpoint");
        builder.append(",name=" + StringUtils.capitalize((String)endpoint.getId()));
        String baseName = builder.toString();
        if (this.mBeanServer != null && this.hasMBean(baseName)) {
            builder.append(",context=" + this.contextId);
        }
        if (this.properties.isUniqueNames()) {
            String identity = ObjectUtils.getIdentityHexString((Object)endpoint);
            builder.append(",identity=" + identity);
        }
        builder.append(this.getStaticNames());
        return ObjectNameManager.getInstance((String)builder.toString());
    }

    private boolean hasMBean(String baseObjectName) throws MalformedObjectNameException {
        ObjectName query = new ObjectName(baseObjectName + ",*");
        return !this.mBeanServer.queryNames(query, null).isEmpty();
    }

    private String getStaticNames() {
        if (this.properties.getStaticNames().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.properties.getStaticNames().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> builder.append("," + name + "=" + value)));
        return builder.toString();
    }
}

