/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai.api;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.util.CollectionUtils;

public class ZhiPuAiStreamFunctionCallingHelper {
    public ZhiPuAiApi.ChatCompletionChunk merge(ZhiPuAiApi.ChatCompletionChunk previous, ZhiPuAiApi.ChatCompletionChunk current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        Long created = current.created() != null ? current.created() : previous.created();
        String model = current.model() != null ? current.model() : previous.model();
        String systemFingerprint = current.systemFingerprint() != null ? current.systemFingerprint() : previous.systemFingerprint();
        String object = current.object() != null ? current.object() : previous.object();
        ZhiPuAiApi.ChatCompletionChunk.ChunkChoice previousChoice0 = CollectionUtils.isEmpty(previous.choices()) ? null : previous.choices().get(0);
        ZhiPuAiApi.ChatCompletionChunk.ChunkChoice currentChoice0 = CollectionUtils.isEmpty(current.choices()) ? null : current.choices().get(0);
        ZhiPuAiApi.ChatCompletionChunk.ChunkChoice choice = this.merge(previousChoice0, currentChoice0);
        List<ZhiPuAiApi.ChatCompletionChunk.ChunkChoice> chunkChoices = choice == null ? List.of() : List.of(choice);
        return new ZhiPuAiApi.ChatCompletionChunk(id, chunkChoices, created, model, systemFingerprint, object);
    }

    private ZhiPuAiApi.ChatCompletionChunk.ChunkChoice merge(ZhiPuAiApi.ChatCompletionChunk.ChunkChoice previous, ZhiPuAiApi.ChatCompletionChunk.ChunkChoice current) {
        if (previous == null) {
            return current;
        }
        ZhiPuAiApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        Integer index = current.index() != null ? current.index() : previous.index();
        ZhiPuAiApi.ChatCompletionMessage message = this.merge(previous.delta(), current.delta());
        ZhiPuAiApi.LogProbs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new ZhiPuAiApi.ChatCompletionChunk.ChunkChoice(finishReason, index, message, logprobs);
    }

    private ZhiPuAiApi.ChatCompletionMessage merge(ZhiPuAiApi.ChatCompletionMessage previous, ZhiPuAiApi.ChatCompletionMessage current) {
        String content;
        String string = current.content() != null ? current.content() : (content = previous.content() != null ? previous.content() : "");
        String reasoningContent = current.reasoningContent() != null ? current.reasoningContent() : (previous.reasoningContent() != null ? previous.reasoningContent() : "");
        ZhiPuAiApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : ZhiPuAiApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = current.name() != null ? current.name() : previous.name();
        String toolCallId = current.toolCallId() != null ? current.toolCallId() : previous.toolCallId();
        ArrayList<ZhiPuAiApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<ZhiPuAiApi.ChatCompletionMessage.ToolCall>();
        ZhiPuAiApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (current.toolCalls() != null) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            ZhiPuAiApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (currentToolCall.id() != null) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new ZhiPuAiApi.ChatCompletionMessage(content, role, name, toolCallId, toolCalls, reasoningContent);
    }

    private ZhiPuAiApi.ChatCompletionMessage.ToolCall merge(ZhiPuAiApi.ChatCompletionMessage.ToolCall previous, ZhiPuAiApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        String type = current.type() != null ? current.type() : previous.type();
        ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new ZhiPuAiApi.ChatCompletionMessage.ToolCall(id, type, function);
    }

    private ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction merge(ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction previous, ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = current.name() != null ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(ZhiPuAiApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        ZhiPuAiApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.delta().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(ZhiPuAiApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        ZhiPuAiApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return choice.finishReason() == ZhiPuAiApi.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public ZhiPuAiApi.ChatCompletion chunkToChatCompletion(ZhiPuAiApi.ChatCompletionChunk chunk) {
        List<ZhiPuAiApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(chunkChoice -> new ZhiPuAiApi.ChatCompletion.Choice(chunkChoice.finishReason(), chunkChoice.index(), chunkChoice.delta(), chunkChoice.logprobs())).toList();
        return new ZhiPuAiApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.systemFingerprint(), "chat.completion", null);
    }
}

