/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiAudioTranscriptionOptions
implements AudioTranscriptionOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="response_format")
    private OpenAiAudioApi.TranscriptResponseFormat responseFormat;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="language")
    private String language;
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="timestamp_granularities")
    private OpenAiAudioApi.TranscriptionRequest.GranularityType granularityType;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public OpenAiAudioApi.TranscriptResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(OpenAiAudioApi.TranscriptResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public OpenAiAudioApi.TranscriptionRequest.GranularityType getGranularityType() {
        return this.granularityType;
    }

    public void setGranularityType(OpenAiAudioApi.TranscriptionRequest.GranularityType granularityType) {
        this.granularityType = granularityType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.prompt == null ? 0 : this.prompt.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.responseFormat == null ? 0 : this.responseFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenAiAudioTranscriptionOptions other = (OpenAiAudioTranscriptionOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.prompt == null ? other.prompt != null : !this.prompt.equals(other.prompt)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.responseFormat == null ? other.responseFormat != null : !this.responseFormat.equals((Object)other.responseFormat));
    }

    public static final class Builder {
        protected OpenAiAudioTranscriptionOptions options;

        public Builder() {
            this.options = new OpenAiAudioTranscriptionOptions();
        }

        public Builder(OpenAiAudioTranscriptionOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder language(String language) {
            this.options.language = language;
            return this;
        }

        public Builder prompt(String prompt) {
            this.options.prompt = prompt;
            return this;
        }

        public Builder responseFormat(OpenAiAudioApi.TranscriptResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder temperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder granularityType(OpenAiAudioApi.TranscriptionRequest.GranularityType granularityType) {
            this.options.granularityType = granularityType;
            return this;
        }

        public OpenAiAudioTranscriptionOptions build() {
            return this.options;
        }
    }
}

