/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.neo4j.filter;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class Neo4jVectorFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        if (expression.type() == Filter.ExpressionType.NIN) {
            this.doNot(new Filter.Expression(Filter.ExpressionType.NOT, (Filter.Operand)new Filter.Expression(Filter.ExpressionType.IN, expression.left(), expression.right())), context);
        } else {
            this.convertOperand(expression.left(), context);
            context.append(this.getOperationSymbol(expression));
            this.convertOperand(expression.right(), context);
        }
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " AND ";
            case Filter.ExpressionType.OR -> " OR ";
            case Filter.ExpressionType.EQ -> " = ";
            case Filter.ExpressionType.NE -> " <> ";
            case Filter.ExpressionType.LT -> " < ";
            case Filter.ExpressionType.LTE -> " <= ";
            case Filter.ExpressionType.GT -> " > ";
            case Filter.ExpressionType.GTE -> " >= ";
            case Filter.ExpressionType.IN -> " IN ";
            case Filter.ExpressionType.NOT, Filter.ExpressionType.NIN -> " NOT ";
            default -> throw new RuntimeException("Not supported expression type: " + String.valueOf(exp.type()));
        };
    }

    protected void doNot(Filter.Expression expression, StringBuilder context) {
        Filter.ExpressionType expressionType = expression.type();
        if (expressionType != Filter.ExpressionType.NOT) {
            throw new RuntimeException("Unsupported expression type %s. Only NOT is supported here".formatted(expressionType));
        }
        context.append("NOT ").append(this.convertOperand(expression.left()));
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("node.").append("`metadata.").append(key.key().replace("\"", "")).append("`");
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

