/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationContext;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationDocumentation;
import org.springframework.ai.chat.client.advisor.observation.DefaultAdvisorObservationConvention;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class DefaultAroundAdvisorChain
implements CallAroundAdvisorChain,
StreamAroundAdvisorChain {
    public static final AdvisorObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultAdvisorObservationConvention();
    private final Deque<CallAroundAdvisor> callAroundAdvisors;
    private final Deque<StreamAroundAdvisor> streamAroundAdvisors;
    private final ObservationRegistry observationRegistry;

    DefaultAroundAdvisorChain(ObservationRegistry observationRegistry, Deque<CallAroundAdvisor> callAroundAdvisors, Deque<StreamAroundAdvisor> streamAroundAdvisors) {
        Assert.notNull((Object)observationRegistry, (String)"the observationRegistry must be non-null");
        Assert.notNull(callAroundAdvisors, (String)"the callAroundAdvisors must be non-null");
        Assert.notNull(streamAroundAdvisors, (String)"the streamAroundAdvisors must be non-null");
        this.observationRegistry = observationRegistry;
        this.callAroundAdvisors = callAroundAdvisors;
        this.streamAroundAdvisors = streamAroundAdvisors;
    }

    public static Builder builder(ObservationRegistry observationRegistry) {
        return new Builder(observationRegistry);
    }

    @Override
    public AdvisedResponse nextAroundCall(AdvisedRequest advisedRequest) {
        if (this.callAroundAdvisors.isEmpty()) {
            throw new IllegalStateException("No AroundAdvisor available to execute");
        }
        CallAroundAdvisor advisor = this.callAroundAdvisors.pop();
        AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).advisorType(AdvisorObservationContext.Type.AROUND).advisedRequest(advisedRequest).advisorRequestContext(advisedRequest.adviseContext()).order(advisor.getOrder()).build();
        return (AdvisedResponse)AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> advisor.aroundCall(advisedRequest, this));
    }

    @Override
    public Flux<AdvisedResponse> nextAroundStream(AdvisedRequest advisedRequest) {
        return Flux.deferContextual(contextView -> {
            if (this.streamAroundAdvisors.isEmpty()) {
                return Flux.error((Throwable)new IllegalStateException("No AroundAdvisor available to execute"));
            }
            StreamAroundAdvisor advisor = this.streamAroundAdvisors.pop();
            AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).advisorType(AdvisorObservationContext.Type.AROUND).advisedRequest(advisedRequest).advisorRequestContext(advisedRequest.adviseContext()).order(advisor.getOrder()).build();
            Observation observation = AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return Flux.defer(() -> advisor.aroundStream(advisedRequest, this)).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
        });
    }

    public static class Builder {
        private final ObservationRegistry observationRegistry;
        private final Deque<CallAroundAdvisor> callAroundAdvisors;
        private final Deque<StreamAroundAdvisor> streamAroundAdvisors;

        public Builder(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            this.callAroundAdvisors = new ConcurrentLinkedDeque<CallAroundAdvisor>();
            this.streamAroundAdvisors = new ConcurrentLinkedDeque<StreamAroundAdvisor>();
        }

        public Builder push(Advisor aroundAdvisor) {
            Assert.notNull((Object)aroundAdvisor, (String)"the aroundAdvisor must be non-null");
            return this.pushAll(List.of(aroundAdvisor));
        }

        public Builder pushAll(List<? extends Advisor> advisors) {
            Assert.notNull(advisors, (String)"the advisors must be non-null");
            if (!CollectionUtils.isEmpty(advisors)) {
                List<StreamAroundAdvisor> streamAroundAdvisorList;
                List<CallAroundAdvisor> callAroundAdvisorList = advisors.stream().filter(a -> a instanceof CallAroundAdvisor).map(a -> (CallAroundAdvisor)a).toList();
                if (!CollectionUtils.isEmpty(callAroundAdvisorList)) {
                    callAroundAdvisorList.forEach(this.callAroundAdvisors::push);
                }
                if (!CollectionUtils.isEmpty(streamAroundAdvisorList = advisors.stream().filter(a -> a instanceof StreamAroundAdvisor).map(a -> (StreamAroundAdvisor)a).toList())) {
                    streamAroundAdvisorList.forEach(this.streamAroundAdvisors::push);
                }
                this.reOrder();
            }
            return this;
        }

        private void reOrder() {
            ArrayList<CallAroundAdvisor> callAdvisors = new ArrayList<CallAroundAdvisor>(this.callAroundAdvisors);
            OrderComparator.sort(callAdvisors);
            this.callAroundAdvisors.clear();
            callAdvisors.forEach(this.callAroundAdvisors::addLast);
            ArrayList<StreamAroundAdvisor> streamAdvisors = new ArrayList<StreamAroundAdvisor>(this.streamAroundAdvisors);
            OrderComparator.sort(streamAdvisors);
            this.streamAroundAdvisors.clear();
            streamAdvisors.forEach(this.streamAroundAdvisors::addLast);
        }

        public DefaultAroundAdvisorChain build() {
            return new DefaultAroundAdvisorChain(this.observationRegistry, this.callAroundAdvisors, this.streamAroundAdvisors);
        }
    }
}

