/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.zhipuai.autoconfigure;

import org.springframework.ai.model.zhipuai.autoconfigure.ZhiPuAiConnectionProperties;
import org.springframework.ai.model.zhipuai.autoconfigure.ZhiPuAiImageProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.ai.zhipuai.ZhiPuAiImageModel;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.ai.zhipuai.api.ZhiPuAiImageApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={ZhiPuAiApi.class})
@ConditionalOnProperty(name={"spring.ai.model.image"}, havingValue="zhipuai", matchIfMissing=true)
@EnableConfigurationProperties(value={ZhiPuAiConnectionProperties.class, ZhiPuAiImageProperties.class})
public class ZhiPuAiImageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZhiPuAiImageModel zhiPuAiImageModel(ZhiPuAiConnectionProperties commonProperties, ZhiPuAiImageProperties imageProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"ZhiPuAI API key must be set");
        Assert.hasText((String)baseUrl, (String)"ZhiPuAI base URL must be set");
        ZhiPuAiImageApi zhiPuAiImageApi = new ZhiPuAiImageApi(baseUrl, apiKey, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        return new ZhiPuAiImageModel(zhiPuAiImageApi, imageProperties.getOptions(), retryTemplate);
    }
}

