/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.ollama.autoconfigure;

import org.springframework.ai.model.ollama.autoconfigure.OllamaConnectionDetails;
import org.springframework.ai.model.ollama.autoconfigure.OllamaConnectionProperties;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration
@ConditionalOnClass(value={OllamaApi.class})
@EnableConfigurationProperties(value={OllamaConnectionProperties.class})
public class OllamaApiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OllamaConnectionDetails.class})
    public PropertiesOllamaConnectionDetails ollamaConnectionDetails(OllamaConnectionProperties properties) {
        return new PropertiesOllamaConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public OllamaApi ollamaApi(OllamaConnectionDetails connectionDetails, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider) {
        return OllamaApi.builder().baseUrl(connectionDetails.getBaseUrl()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).webClientBuilder((WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder)).build();
    }

    static class PropertiesOllamaConnectionDetails
    implements OllamaConnectionDetails {
        private final OllamaConnectionProperties properties;

        PropertiesOllamaConnectionDetails(OllamaConnectionProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getBaseUrl() {
            return this.properties.getBaseUrl();
        }
    }
}

