/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.autoconfigure.properties;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.transport.ServerParameters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.ai.mcp.client.stdio")
public class McpStdioClientProperties {
    public static final String CONFIG_PREFIX = "spring.ai.mcp.client.stdio";
    private Resource serversConfiguration;
    private final Map<String, Parameters> connections = new HashMap<String, Parameters>();

    public Resource getServersConfiguration() {
        return this.serversConfiguration;
    }

    public void setServersConfiguration(Resource stdioConnectionResources) {
        this.serversConfiguration = stdioConnectionResources;
    }

    public Map<String, Parameters> getConnections() {
        return this.connections;
    }

    private Map<String, ServerParameters> resourceToServerParameters() {
        try {
            Map stdioConnection = (Map)new ObjectMapper().readValue(this.serversConfiguration.getInputStream(), (TypeReference)new TypeReference<Map<String, Map<String, Parameters>>>(){});
            Map mcpServerJsonConfig = (Map)stdioConnection.entrySet().iterator().next().getValue();
            return mcpServerJsonConfig.entrySet().stream().collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> {
                Parameters parameters = (Parameters)kv.getValue();
                return ServerParameters.builder((String)parameters.command()).args(parameters.args()).env(parameters.env()).build();
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read stdio connection resource", e);
        }
    }

    public Map<String, ServerParameters> toServerParameters() {
        HashMap<String, ServerParameters> serverParameters = new HashMap<String, ServerParameters>();
        if (this.serversConfiguration != null) {
            serverParameters.putAll(this.resourceToServerParameters());
        }
        for (Map.Entry<String, Parameters> entry : this.connections.entrySet()) {
            serverParameters.put(entry.getKey(), entry.getValue().toServerParameters());
        }
        return serverParameters;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public record Parameters(@JsonProperty(value="command") String command, @JsonProperty(value="args") List<String> args, @JsonProperty(value="env") Map<String, String> env) {
        public ServerParameters toServerParameters() {
            return ServerParameters.builder((String)this.command()).args(this.args()).env(this.env()).build();
        }
    }
}

