/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.synchronization;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.serialization.SerializableContract;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3042")
public class WriteObjectTheOnlySynchronizedMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        String className = enclosingClass.type().fullyQualifiedName();
        MethodMatcher writeObjectMatcher = SerializableContract.writeObjectMatcher(className);
        if (writeObjectMatcher.matches(methodTree) && ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.SYNCHRONIZED)) {
            SynchronizationVisitor visitor = new SynchronizationVisitor(methodTree);
            enclosingClass.declaration().accept((TreeVisitor)visitor);
            if (!visitor.moreThanSingleLock) {
                this.reportIssue((Tree)ModifiersUtils.getModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.SYNCHRONIZED), "Remove this \"synchronized\" keyword.");
            }
        }
    }

    private static class SynchronizationVisitor
    extends BaseTreeVisitor {
        private final MethodTree writeObjectMethodTree;
        private boolean moreThanSingleLock;

        public SynchronizationVisitor(MethodTree writeObjectMethodTree) {
            this.writeObjectMethodTree = writeObjectMethodTree;
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            this.moreThanSingleLock = true;
        }

        public void visitMethod(MethodTree tree) {
            if (tree.equals(this.writeObjectMethodTree) || this.moreThanSingleLock) {
                return;
            }
            if (ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.SYNCHRONIZED)) {
                this.moreThanSingleLock = true;
                return;
            }
            super.visitMethod(tree);
        }
    }
}

