/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.PatternUtils;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.PackageUtils;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="UndocumentedApi")
@RspecKey(value="S1176")
public class UndocumentedApiCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final String DEFAULT_FOR_CLASSES = "**.api.**";
    private static final String DEFAULT_EXCLUSION = "**.internal.**";
    @RuleProperty(key="forClasses", description="Pattern of classes which should adhere to this constraint. Ex : **.api.**", defaultValue="**.api.**")
    public String forClasses = "**.api.**";
    @RuleProperty(key="exclusion", description="Pattern of classes which are excluded from adhering to this constraint.", defaultValue="**.internal.**")
    public String exclusion = "**.internal.**";
    private WildcardPattern[] inclusionPatterns;
    private WildcardPattern[] exclusionPatterns;
    private final Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private final Deque<Tree> currentParents = new LinkedList<Tree>();
    private String packageName;
    private final Pattern setterPattern = Pattern.compile("set[A-Z].*");
    private final Pattern getterPattern = Pattern.compile("(get|is)[A-Z].*");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        this.classTrees.clear();
        this.currentParents.clear();
        this.packageName = "";
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.packageName = PackageUtils.packageName((PackageDeclarationTree)tree.packageDeclaration(), (String)".");
        super.visitCompilationUnit(tree);
    }

    public void visitNewClass(NewClassTree tree) {
    }

    public void visitClass(ClassTree tree) {
        this.visitNode((Tree)tree, (Tree)tree.simpleName(), tree.symbol().metadata());
        super.visitClass(tree);
        this.classTrees.pop();
        this.currentParents.pop();
    }

    public void visitVariable(VariableTree tree) {
        this.visitNode((Tree)tree, (Tree)tree.simpleName(), tree.symbol().metadata());
        super.visitVariable(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.visitNode((Tree)tree, (Tree)tree.simpleName(), tree.symbol().metadata());
        super.visitMethod(tree);
        this.currentParents.pop();
    }

    private void visitNode(Tree tree, Tree reportTree, SymbolMetadata symbolMetadata) {
        if (!this.isExcluded(tree, symbolMetadata)) {
            Javadoc javadoc = new Javadoc(tree);
            if (javadoc.noMainDescription() && !this.isNonVoidMethodWithNoParameter(tree, javadoc)) {
                this.context.reportIssue((JavaCheck)this, reportTree, "Document this public " + UndocumentedApiCheck.getType(tree) + " by adding an explicit description.");
            } else {
                List<String> undocumentedExceptions;
                List<String> undocumentedParameters = javadoc.undocumentedParameters(tree);
                if (!undocumentedParameters.isEmpty()) {
                    this.context.reportIssue((JavaCheck)this, reportTree, "Document the parameter(s): " + undocumentedParameters.stream().collect(Collectors.joining(", ")));
                }
                if (this.hasNonVoidReturnType(tree) && javadoc.noReturnDescription()) {
                    this.context.reportIssue((JavaCheck)this, reportTree, "Document this method return value.");
                }
                if (!(undocumentedExceptions = javadoc.undocumentedThrownExceptions(tree)).isEmpty()) {
                    this.context.reportIssue((JavaCheck)this, reportTree, "Document this method thrown exception(s): " + undocumentedExceptions.stream().collect(Collectors.joining(", ")));
                }
            }
        }
    }

    private boolean isNonVoidMethodWithNoParameter(Tree tree, Javadoc javadoc) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            return false;
        }
        return this.hasNonVoidReturnType(tree) && ((MethodTree)tree).parameters().isEmpty() && !javadoc.noReturnDescription();
    }

    private static String getType(Tree tree) {
        switch (tree.kind()) {
            case CONSTRUCTOR: {
                return "constructor";
            }
            case METHOD: {
                return "method";
            }
            case VARIABLE: {
                return "field";
            }
            case CLASS: {
                return "class";
            }
            case INTERFACE: {
                return "interface";
            }
            case ENUM: {
                return "enum";
            }
            case ANNOTATION_TYPE: {
                return "annotation";
            }
        }
        return "";
    }

    private boolean isExcluded(Tree tree, SymbolMetadata symbolMetadata) {
        return !this.isPublicApi(tree) || this.isAccessor(tree) || !this.isMatchingInclusionPattern() || this.isMatchingExclusionPattern() || UndocumentedApiCheck.isOverridingMethod(tree) || UndocumentedApiCheck.isVisibleForTestingMethod(tree, symbolMetadata) || UndocumentedApiCheck.hasDeprecatedAnnotation(symbolMetadata);
    }

    private boolean isAccessor(Tree tree) {
        if (!this.classTrees.isEmpty() && tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)tree;
            String name = methodTree.simpleName().name();
            return this.setterPattern.matcher(name).matches() && methodTree.parameters().size() == 1 || this.getterPattern.matcher(name).matches() && methodTree.parameters().isEmpty();
        }
        return false;
    }

    private boolean isPublicApi(Tree tree) {
        Tree currentParent = this.currentParents.peek();
        if (tree.is(CLASS_KINDS)) {
            this.classTrees.push((ClassTree)tree);
            this.currentParents.push(tree);
        } else if (tree.is(METHOD_KINDS)) {
            this.currentParents.push(tree);
        }
        return PublicApiChecker.isPublicApi((Tree)currentParent, (Tree)tree);
    }

    private boolean isMatchingInclusionPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getInclusionPatterns(), (String)this.className());
    }

    private boolean isMatchingExclusionPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getExclusionPatterns(), (String)this.className());
    }

    private static boolean isOverridingMethod(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && BooleanUtils.isTrue((Boolean)((MethodTreeImpl)tree).isOverriding());
    }

    private static boolean isVisibleForTestingMethod(Tree tree, SymbolMetadata symbolMetadata) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && (symbolMetadata.isAnnotatedWith("org.fest.util.VisibleForTesting") || symbolMetadata.isAnnotatedWith("com.google.common.annotations.VisibleForTesting"));
    }

    private static boolean hasDeprecatedAnnotation(SymbolMetadata symbolMetadata) {
        return symbolMetadata.isAnnotatedWith("java.lang.Deprecated");
    }

    private String className() {
        String className = this.packageName;
        IdentifierTree identifierTree = this.classTrees.peek().simpleName();
        if (identifierTree != null) {
            className = className + "." + identifierTree.name();
        }
        return className;
    }

    private WildcardPattern[] getInclusionPatterns() {
        if (this.inclusionPatterns == null) {
            if (StringUtils.isEmpty((String)this.forClasses)) {
                this.forClasses = "**";
            }
            this.inclusionPatterns = PatternUtils.createPatterns(this.forClasses);
        }
        return this.inclusionPatterns;
    }

    private WildcardPattern[] getExclusionPatterns() {
        if (this.exclusionPatterns == null) {
            this.exclusionPatterns = StringUtils.isEmpty((String)this.exclusion) ? new WildcardPattern[0] : PatternUtils.createPatterns(this.exclusion);
        }
        return this.exclusionPatterns;
    }

    private boolean hasNonVoidReturnType(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !this.classTrees.peek().is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE})) {
            TypeTree returnType = ((MethodTree)tree).returnType();
            return returnType == null || !returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) || !"void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }

    private static class Javadoc {
        private static final Pattern PARAMETER_JAVADOC_PATTERN = Pattern.compile(".*@param\\s++(?<name>\\S*)(\\s++)?(?<descr>.+)?");
        private static final Pattern EXCEPTION_JAVADOC_PATTERN = Pattern.compile(".*@throws\\s++(?<name>\\S*)(\\s++)?(?<descr>.+)?");
        private static final Pattern RETURN_JAVADOC_PATTERN = Pattern.compile(".*@return(\\s++)?(?<descr>.+)?");
        private static final Set<String> PLACEHOLDERS = ImmutableSet.of((Object)"TODO", (Object)"FIXME", (Object)"...", (Object)".");
        private final String mainDescription;
        private final Map<String, List<String>> parameters;
        private final Map<String, List<String>> thrownExceptions;
        private final String returnDescription;

        Javadoc(Tree tree) {
            String javadoc = PublicApiChecker.getApiJavadoc((Tree)tree);
            List<String> lines = Javadoc.cleanedlines(javadoc);
            this.mainDescription = Javadoc.extractMainDescription(lines);
            this.parameters = Javadoc.extractToMap(lines, PARAMETER_JAVADOC_PATTERN);
            this.thrownExceptions = Javadoc.extractToMap(lines, EXCEPTION_JAVADOC_PATTERN);
            this.returnDescription = Javadoc.extractReturnDescription(lines);
        }

        public boolean noMainDescription() {
            return Javadoc.isEmptyDescription(this.mainDescription);
        }

        public boolean noReturnDescription() {
            return Javadoc.isEmptyDescription(this.returnDescription);
        }

        public List<String> undocumentedParameters(Tree tree) {
            return Javadoc.getParameters(tree).stream().filter(name -> Javadoc.isEmptyDescription(this.parameters.get(name))).collect(Collectors.toList());
        }

        public List<String> undocumentedThrownExceptions(Tree tree) {
            List<String> exceptionNames = Javadoc.getExceptions(tree);
            if (exceptionNames.size() == 1 && "Exception".equals(exceptionNames.get(0)) && !this.thrownExceptions.isEmpty()) {
                return this.thrownExceptions.entrySet().stream().filter(e -> Javadoc.isEmptyDescription((List)e.getValue())).map(Map.Entry::getKey).map(Javadoc::toSimpleName).collect(Collectors.toList());
            }
            return exceptionNames.stream().filter(this::noDescriptionForException).map(Javadoc::toSimpleName).collect(Collectors.toList());
        }

        private boolean noDescriptionForException(String exceptionName) {
            List<String> descriptions = this.thrownExceptions.get(exceptionName);
            if (descriptions == null) {
                descriptions = this.thrownExceptions.get(Javadoc.toSimpleName(exceptionName));
            }
            if (descriptions == null) {
                descriptions = this.thrownExceptions.entrySet().stream().filter(e -> Javadoc.toSimpleName((String)e.getKey()).equals(exceptionName)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
            }
            return Javadoc.isEmptyDescription(descriptions);
        }

        private static String toSimpleName(String exceptionName) {
            int lastDot = exceptionName.lastIndexOf(46);
            if (lastDot != -1) {
                return exceptionName.substring(lastDot + 1);
            }
            return exceptionName;
        }

        private static boolean isEmptyDescription(@Nullable List<String> descriptions) {
            return descriptions == null || descriptions.isEmpty() || descriptions.stream().anyMatch(Javadoc::isEmptyDescription);
        }

        private static boolean isEmptyDescription(@Nullable String part) {
            return part == null || part.trim().isEmpty() || PLACEHOLDERS.contains(part);
        }

        private static List<String> getParameters(Tree tree) {
            if (tree.is(METHOD_KINDS)) {
                return ((MethodTree)tree).parameters().stream().map(VariableTree::simpleName).map(IdentifierTree::name).collect(Collectors.toList());
            }
            if (tree.is(CLASS_KINDS)) {
                return ((ClassTree)tree).typeParameters().stream().map(TypeParameterTree::identifier).map(IdentifierTree::name).map(name -> "<" + name + ">").collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        private static List<String> getExceptions(Tree tree) {
            if (tree.is(METHOD_KINDS)) {
                return ((MethodTree)tree).throwsClauses().stream().map(Javadoc::exceptionName).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        private static String exceptionName(TypeTree typeTree) {
            switch (typeTree.kind()) {
                case IDENTIFIER: {
                    return ((IdentifierTree)typeTree).name();
                }
                case MEMBER_SELECT: {
                    return ExpressionsHelper.concatenate((ExpressionTree)((MemberSelectExpressionTree)typeTree));
                }
            }
            throw new IllegalStateException("Exceptions can not be specified other than with an identifier or a fully qualified name.");
        }

        private static List<String> cleanedlines(@Nullable String javadoc) {
            if (javadoc == null) {
                return Collections.emptyList();
            }
            String[] lines = Javadoc.cleanupJavadoc(javadoc).split("\\r?\\n");
            return Arrays.stream(lines).map(String::trim).collect(Collectors.toList());
        }

        private static String cleanupJavadoc(String javadoc) {
            return javadoc.trim().substring(3).replace("*/", "").replace("*", "").trim();
        }

        private static String extractMainDescription(List<String> lines) {
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if (line.matches("(@param|@throws|@return).*")) break;
                sb.append(line).append(" ");
            }
            return sb.toString().trim();
        }

        private static Map<String, List<String>> extractToMap(List<String> lines, Pattern pattern) {
            HashMap<String, List<String>> results = new HashMap<String, List<String>>();
            for (int i = 0; i < lines.size(); ++i) {
                Matcher matcher = pattern.matcher(lines.get(i));
                if (!matcher.matches()) continue;
                List descriptions = results.computeIfAbsent(matcher.group("name"), key -> new ArrayList());
                String newDescription = Javadoc.getNextLineIfNeeded(lines, i, matcher.group("descr"));
                if (newDescription == null) continue;
                descriptions.add(newDescription);
            }
            return results;
        }

        private static String extractReturnDescription(List<String> lines) {
            for (int i = 0; i < lines.size(); ++i) {
                String returnDescription;
                String line = lines.get(i);
                Matcher matcher = RETURN_JAVADOC_PATTERN.matcher(line);
                if (!matcher.matches() || (returnDescription = Javadoc.getNextLineIfNeeded(lines, i, matcher.group("descr"))) == null) continue;
                return returnDescription;
            }
            return "";
        }

        private static String getNextLineIfNeeded(List<String> lines, int currentIndex, @Nullable String currrentValue) {
            String nextLine;
            if (currrentValue == null && currentIndex < lines.size() - 1 && !(nextLine = lines.get(currentIndex + 1)).startsWith("@")) {
                return nextLine;
            }
            return currrentValue;
        }
    }
}

