/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1217")
public class ThreadRunCheck
extends AbstractMethodDetection {
    private static final MethodMatcher THREAD_RUN_METHOD_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.Thread")).name("run").withAnyParameters();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)THREAD_RUN_METHOD_MATCHER);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD}); parent = parent.parent()) {
        }
        if (parent != null && THREAD_RUN_METHOD_MATCHER.matches((MethodTree)parent)) {
            return;
        }
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "Call the method Thread.start() to execute the content of the run() method in a dedicated thread.");
    }
}

