/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;

@Rule(key="S128")
public class SwitchCaseWithoutBreakCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitSwitchStatement(SwitchStatementTree switchStatement) {
        switchStatement.cases().stream().limit(Math.max(0, switchStatement.cases().size() - 1)).forEach(caseGroup -> {
            CaseLabelTree caseLabel = (CaseLabelTree)caseGroup.labels().get(caseGroup.labels().size() - 1);
            if (Lists.reverse((List)caseGroup.body()).stream().noneMatch(SwitchCaseWithoutBreakCheck::isUnconditionalExit) && !SwitchCaseWithoutBreakCheck.intentionalFallThrough(switchStatement, caseGroup)) {
                this.context.reportIssue((JavaCheck)this, (Tree)caseLabel, "End this switch case with an unconditional break, return or throw statement.");
            }
        });
        super.visitSwitchStatement(switchStatement);
    }

    private static boolean intentionalFallThrough(SwitchStatementTree switchStatement, CaseGroupTree caseGroup) {
        FallThroughCommentVisitor visitor = new FallThroughCommentVisitor();
        CaseGroupTree nextCaseGroup = (CaseGroupTree)switchStatement.cases().get(switchStatement.cases().indexOf(caseGroup) + 1);
        ImmutableList treesToScan = ImmutableList.builder().addAll((Iterable)caseGroup.body()).add((Object)nextCaseGroup.firstToken()).build();
        visitor.scan((List)treesToScan);
        return visitor.hasComment;
    }

    private static boolean isUnconditionalExit(Tree syntaxNode) {
        switch (syntaxNode.kind()) {
            case BREAK_STATEMENT: 
            case THROW_STATEMENT: 
            case RETURN_STATEMENT: 
            case CONTINUE_STATEMENT: {
                return true;
            }
            case BLOCK: {
                return ((BlockTree)syntaxNode).body().stream().anyMatch(SwitchCaseWithoutBreakCheck::isUnconditionalExit);
            }
            case TRY_STATEMENT: {
                return SwitchCaseWithoutBreakCheck.isUnconditionalExitInTryCatchStatement((TryStatementTree)syntaxNode);
            }
            case IF_STATEMENT: {
                return SwitchCaseWithoutBreakCheck.isUnconditionalExitInIfStatement((IfStatementTree)syntaxNode);
            }
        }
        return false;
    }

    private static boolean isUnconditionalExitInTryCatchStatement(TryStatementTree tryStatement) {
        return SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)tryStatement.block()) && tryStatement.catches().stream().allMatch(catchTree -> SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)catchTree.block()));
    }

    private static boolean isUnconditionalExitInIfStatement(IfStatementTree ifStatement) {
        if (!SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)ifStatement.thenStatement())) {
            return false;
        }
        StatementTree elseStatement = ifStatement.elseStatement();
        if (elseStatement == null) {
            return false;
        }
        return SwitchCaseWithoutBreakCheck.isUnconditionalExit((Tree)elseStatement);
    }

    private static class FallThroughCommentVisitor
    extends SubscriptionVisitor {
        private static final Pattern FALL_THROUGH_PATTERN = Pattern.compile("falls?\\-?thro?u[gh]?", 2);
        boolean hasComment = false;

        private FallThroughCommentVisitor() {
        }

        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TRIVIA);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            if (!this.hasComment && FALL_THROUGH_PATTERN.matcher(syntaxTrivia.comment()).find()) {
                this.hasComment = true;
            }
        }

        private void scan(List<Tree> trees) {
            for (Tree tree : trees) {
                if (this.hasComment) {
                    return;
                }
                this.scanTree(tree);
            }
        }
    }
}

