/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1132")
public class StringLiteralInsideEqualsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        this.check((MethodInvocationTree)tree);
    }

    private void check(MethodInvocationTree tree) {
        if (StringLiteralInsideEqualsCheck.isEquals(tree.methodSelect()) && tree.arguments().size() == 1 && ((ExpressionTree)tree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            LiteralTree stringLiteral = (LiteralTree)tree.arguments().get(0);
            this.reportIssue((Tree)stringLiteral, "Move the " + stringLiteral.value() + " string literal on the left side of this string comparison.");
        }
    }

    private static boolean isEquals(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return StringLiteralInsideEqualsCheck.isEquals((IdentifierTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return StringLiteralInsideEqualsCheck.isEquals(((MemberSelectExpressionTree)tree).identifier());
        }
        return false;
    }

    private static boolean isEquals(IdentifierTree tree) {
        return "equals".equals(tree.name()) || "equalsIgnoreCase".equals(tree.name());
    }
}

