/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1126")
public class ReturnOfBooleanExpressionsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        StatementTree elseStatementOrNextStatement = ReturnOfBooleanExpressionsCheck.getStatementTree(ifStatementTree);
        if (ReturnOfBooleanExpressionsCheck.hasOneReturnBoolean(elseStatementOrNextStatement) && ReturnOfBooleanExpressionsCheck.hasOneReturnBoolean(ifStatementTree.thenStatement())) {
            this.reportIssue((Tree)ifStatementTree.ifKeyword(), "Replace this if-then-else statement by a single return statement.");
        }
    }

    private static StatementTree getStatementTree(IfStatementTree ifStatementTree) {
        Tree next;
        JavaTree parent;
        List children;
        int indexOfIf;
        StatementTree elseStatementOrNextStatement = ifStatementTree.elseStatement();
        if (elseStatementOrNextStatement == null && (indexOfIf = (children = (parent = (JavaTree)ifStatementTree.parent()).getChildren()).indexOf(ifStatementTree)) < children.size() - 1 && !(next = (Tree)children.get(indexOfIf + 1)).is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
            elseStatementOrNextStatement = (StatementTree)next;
        }
        return elseStatementOrNextStatement;
    }

    private static boolean hasOneReturnBoolean(@Nullable StatementTree statementTree) {
        if (statementTree == null) {
            return false;
        }
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statementTree;
            return block.body().size() == 1 && ReturnOfBooleanExpressionsCheck.isReturnBooleanLiteral((StatementTree)block.body().get(0));
        }
        return ReturnOfBooleanExpressionsCheck.isReturnBooleanLiteral(statementTree);
    }

    private static boolean isReturnBooleanLiteral(StatementTree statementTree) {
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ReturnStatementTree returnStatement = (ReturnStatementTree)statementTree;
            return returnStatement.expression() != null && returnStatement.expression().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL});
        }
        return false;
    }
}

