/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractPrintfChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3457")
public class PrintfMisuseCheck
extends AbstractPrintfChecker {
    private static final MethodMatcher TO_STRING = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("toString").withoutParameter();

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        List args;
        ExpressionTree formatStringTree;
        boolean isMessageFormat = MESSAGE_FORMAT.matches(mit);
        if (isMessageFormat && !mit.symbol().isStatic()) {
            return;
        }
        if (((ExpressionTree)mit.arguments().get(0)).symbolType().is("java.lang.String")) {
            formatStringTree = (ExpressionTree)mit.arguments().get(0);
            args = mit.arguments().subList(1, mit.arguments().size());
        } else {
            formatStringTree = (ExpressionTree)mit.arguments().get(1);
            args = mit.arguments().subList(2, mit.arguments().size());
        }
        if (formatStringTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String formatString = LiteralUtils.trimQuotes((String)((LiteralTree)formatStringTree).value());
            if (isMessageFormat) {
                this.handleMessageFormat(mit, formatString, args);
            } else {
                this.handlePrintfFormat(mit, formatString, args);
            }
        } else if (PrintfMisuseCheck.isConcatenationOnSameLine(formatStringTree)) {
            this.reportIssue((Tree)mit, "Format specifiers should be used instead of string concatenation.");
        }
    }

    @Override
    protected void handlePrintfFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        List<String> params = this.getParameters(formatString, mit);
        if (PrintfMisuseCheck.usesMessageFormat(formatString, params)) {
            this.reportIssue((Tree)mit, "Looks like there is a confusion with the use of java.text.MessageFormat, parameters will be simply ignored here");
            return;
        }
        this.checkLineFeed(formatString, mit);
        if (this.checkEmptyParams(mit, params)) {
            return;
        }
        PrintfMisuseCheck.cleanupLineSeparator(params);
        if (!params.isEmpty() && PrintfMisuseCheck.argIndexes(params).size() <= args.size()) {
            this.verifyParameters(mit, args, params);
        }
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, List<String> params) {
        int index = 0;
        ArrayList<ExpressionTree> unusedArgs = new ArrayList<ExpressionTree>(args);
        Iterator<String> iterator = params.iterator();
        while (iterator.hasNext()) {
            String rawParam;
            String param = rawParam = iterator.next();
            int argIndex = index++;
            if (param.contains("$")) {
                argIndex = PrintfMisuseCheck.getIndex(param) - 1;
                if (argIndex == -1) {
                    return;
                }
                param = param.substring(param.indexOf(36) + 1);
            } else if (param.charAt(0) == '<') {
                argIndex = Math.max(0, argIndex - 1);
            }
            ExpressionTree argExpressionTree = args.get(argIndex);
            unusedArgs.remove(argExpressionTree);
            Type argType = argExpressionTree.symbolType();
            this.checkBoolean(mit, param, argType);
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    @Override
    protected void handleMessageFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        ExpressionTree firstArg;
        String newFormatString = PrintfMisuseCheck.cleanupDoubleQuote(formatString);
        Set<Integer> indexes = PrintfMisuseCheck.getMessageFormatIndexes(newFormatString);
        ListTree newArgs = args;
        if (newArgs.size() == 1 && (firstArg = newArgs.get(0)).symbolType().isArray()) {
            if (PrintfMisuseCheck.isNewArrayWithInitializers(firstArg)) {
                newArgs = ((NewArrayTree)firstArg).initializers();
            } else {
                return;
            }
        }
        if (this.checkEmptyParams(mit, indexes)) {
            return;
        }
        this.checkToStringInvocation((List<ExpressionTree>)newArgs);
        this.verifyParameters(mit, (List<ExpressionTree>)newArgs, indexes);
    }

    private boolean checkEmptyParams(MethodInvocationTree mit, Collection<?> params) {
        if (params.isEmpty()) {
            this.reportIssue((Tree)mit, "String contains no format specifiers.");
            return true;
        }
        return false;
    }

    private void checkToStringInvocation(List<ExpressionTree> args) {
        args.stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && TO_STRING.matches((MethodInvocationTree)arg)).forEach(arg -> this.reportIssue((Tree)arg, "No need to call toString \"method()\" as formatting and string conversion is done by the Formatter."));
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, Set<Integer> indexes) {
        ArrayList<ExpressionTree> unusedArgs = new ArrayList<ExpressionTree>(args);
        for (int index : indexes) {
            if (index >= args.size()) {
                return;
            }
            unusedArgs.remove(args.get(index));
        }
        this.reportUnusedArgs(mit, args, unusedArgs);
    }

    private void reportUnusedArgs(MethodInvocationTree mit, List<ExpressionTree> args, List<ExpressionTree> unusedArgs) {
        for (ExpressionTree unusedArg : unusedArgs) {
            int i = args.indexOf(unusedArg);
            String stringArgIndex = "first";
            if (i == 1) {
                stringArgIndex = "2nd";
            } else if (i == 2) {
                stringArgIndex = "3rd";
            } else if (i >= 3) {
                stringArgIndex = i + 1 + "th";
            }
            this.reportIssue((Tree)mit, stringArgIndex + " argument is not used.");
        }
    }

    private void checkBoolean(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 'b' && !argType.is("boolean") && !argType.is("java.lang.Boolean")) {
            this.reportIssue((Tree)mit, "Directly inject the boolean value.");
        }
    }

    private void checkLineFeed(String formatString, MethodInvocationTree mit) {
        if (formatString.contains("\\n")) {
            this.reportIssue((Tree)mit, "%n should be used in place of \\n to produce the platform-specific line separator.");
        }
    }

    private static boolean usesMessageFormat(String formatString, List<String> params) {
        return params.isEmpty() && (formatString.contains("{0") || formatString.contains("{1"));
    }

    private static boolean isConcatenationOnSameLine(ExpressionTree formatStringTree) {
        return formatStringTree.is(new Tree.Kind[]{Tree.Kind.PLUS}) && PrintfMisuseCheck.operandsAreOnSameLine((BinaryExpressionTree)formatStringTree);
    }

    private static boolean operandsAreOnSameLine(BinaryExpressionTree formatStringTree) {
        return formatStringTree.leftOperand().firstToken().line() == formatStringTree.rightOperand().firstToken().line();
    }
}

