/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4034")
public class PreferStreamAnyMatchCheck
extends AbstractMethodDetection {
    private static final Set<String> STREAM_TYPES = ImmutableSet.of((Object)"java.util.stream.Stream", (Object)"java.util.stream.IntStream", (Object)"java.util.stream.LongStream", (Object)"java.util.stream.DoubleStream");
    private static final MethodMatcherCollection FIND_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
    private static final MethodMatcherCollection FILTER_METHODS;

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Stream.of("java.util.Optional", "java.util.OptionalInt", "java.util.OptionalLong", "java.util.OptionalDouble").map(type -> MethodMatcher.create().typeDefinition(type).name("isPresent").withoutParameter()).collect(Collectors.toList());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree isPresentMIT) {
        PreferStreamAnyMatchCheck.previousMITInChain(isPresentMIT).filter(arg_0 -> ((MethodMatcherCollection)FIND_METHODS).anyMatch(arg_0)).ifPresent(findMIT -> PreferStreamAnyMatchCheck.previousMITInChain(findMIT).filter(arg_0 -> ((MethodMatcherCollection)FILTER_METHODS).anyMatch(arg_0)).ifPresent(filterMIT -> this.context.reportIssue((JavaCheck)this, (Tree)MethodsHelper.methodName(filterMIT), (Tree)MethodsHelper.methodName(isPresentMIT), "Replace this \"filter()." + MethodsHelper.methodName(findMIT).name() + "().isPresent()\" chain with \"anyMatch()\"")));
    }

    private static Optional<MethodInvocationTree> previousMITInChain(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree previousInvocation = (MethodInvocationTree)expression;
                return Optional.of(previousInvocation);
            }
        }
        return Optional.empty();
    }

    static {
        STREAM_TYPES.forEach(type -> {
            FIND_METHODS.add(MethodMatcher.create().typeDefinition(type).name("findFirst").withoutParameter());
            FIND_METHODS.add(MethodMatcher.create().typeDefinition(type).name("findAny").withoutParameter());
        });
        FILTER_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
        STREAM_TYPES.forEach(type -> FILTER_METHODS.add(MethodMatcher.create().typeDefinition(type).name("filter").withAnyParameters()));
    }
}

