/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1607")
public class IgnoredTestsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        List ignoreAnnotationValues = methodTree.symbol().metadata().valuesForAnnotation("org.junit.Ignore");
        if (ignoreAnnotationValues != null && ignoreAnnotationValues.isEmpty()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Fix or remove this skipped unit test");
        }
    }
}

