/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1872")
public class ClassComparedByNameCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.String").name("equals").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ArrayList<Object> expressionsToCheck = new ArrayList<Object>(2);
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            expressionsToCheck.add(((MemberSelectExpressionTree)mit.methodSelect()).expression());
        }
        expressionsToCheck.add(mit.arguments().get(0));
        boolean useAssignableMessage = expressionsToCheck.size() > 1;
        boolean useClassGetName = false;
        boolean useStackTraceElementGetClassName = false;
        for (ExpressionTree expressionTree : expressionsToCheck) {
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ClassComparedByNameCheck.isParam(((IdentifierTree)expressionTree).symbol())) {
                return;
            }
            ClassGetNameDetector visitor = new ClassGetNameDetector();
            expressionTree.accept((TreeVisitor)visitor);
            useAssignableMessage &= visitor.useClassGetName;
            useClassGetName |= visitor.useClassGetName;
            useStackTraceElementGetClassName |= visitor.useStackTraceElementGetClassName;
        }
        if (useClassGetName && !useStackTraceElementGetClassName) {
            String message = "Use an \"instanceof\" comparison instead.";
            if (useAssignableMessage) {
                message = "Use \"isAssignableFrom\" instead.";
            }
            this.reportIssue((Tree)mit, message);
        }
    }

    private static boolean isParam(Symbol symbol) {
        return symbol.owner().isMethodSymbol() && ((JavaSymbol.MethodJavaSymbol)symbol.owner()).getParameters().scopeSymbols().contains(symbol);
    }

    private static class ClassGetNameDetector
    extends BaseTreeVisitor {
        private boolean useClassGetName = false;
        private boolean useStackTraceElementGetClassName = false;
        private final MethodMatcherCollection methodMatchers = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Class").name("getName").withoutParameter(), MethodMatcher.create().typeDefinition("java.lang.Class").name("getSimpleName").withoutParameter()});
        private final MethodMatcher stackTraceElementMatcher = MethodMatcher.create().typeDefinition("java.lang.StackTraceElement").name("getClassName").withoutParameter();

        private ClassGetNameDetector() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.methodMatchers.anyMatch(tree)) {
                this.useClassGetName = true;
            } else if (this.stackTraceElementMatcher.matches(tree)) {
                this.useStackTraceElementGetClassName = true;
            }
            this.scan((Tree)tree.methodSelect());
        }
    }
}

