/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2387")
public class ChildClassShadowFieldCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> IGNORED_FIELDS = ImmutableSet.of((Object)"serialVersionUID");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree superClass = ((ClassTree)tree).superClass();
        if (superClass != null) {
            Symbol.TypeSymbol superclassSymbol = superClass.symbolType().symbol();
            ((ClassTree)tree).members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).map(VariableTree::simpleName).forEach(fieldSimpleName -> {
                if (!IGNORED_FIELDS.contains(fieldSimpleName.name())) {
                    this.checkForIssue(superclassSymbol, (IdentifierTree)fieldSimpleName);
                }
            });
        }
    }

    private void checkForIssue(Symbol.TypeSymbol classSymbol, IdentifierTree fieldSimpleName) {
        Symbol.TypeSymbol symbol = classSymbol;
        while (symbol != null) {
            if (this.checkMembers(fieldSimpleName, symbol)) {
                return;
            }
            symbol = ChildClassShadowFieldCheck.getSuperclass(symbol);
        }
    }

    private boolean checkMembers(IdentifierTree fieldSimpleName, Symbol.TypeSymbol symbol) {
        for (Symbol member : symbol.memberSymbols()) {
            if (!member.isVariableSymbol() || member.isPrivate() || member.isStatic() || !member.name().equals(fieldSimpleName.name())) continue;
            this.reportIssue((Tree)fieldSimpleName, String.format("\"%s\" is the name of a field in \"%s\".", fieldSimpleName.name(), symbol.name()));
            return true;
        }
        return false;
    }

    @CheckForNull
    private static Symbol.TypeSymbol getSuperclass(Symbol.TypeSymbol symbol) {
        Type superType = symbol.superClass();
        if (superType != null) {
            return superType.symbol();
        }
        return null;
    }
}

