/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="CallToDeprecatedMethod")
@RspecKey(value="S1874")
public class CallToDeprecatedMethodCheck
extends IssuableSubscriptionVisitor {
    private int nestedDeprecationLevel = 0;

    public void scanFile(JavaFileScannerContext context) {
        if (context.getSemanticModel() == null) {
            return;
        }
        super.scanFile(context);
        this.nestedDeprecationLevel = 0;
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IDENTIFIER, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (this.nestedDeprecationLevel == 0) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.checkIdentifierIssue((IdentifierTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR})) {
                this.checkMethodIssue((MethodTree)tree);
            }
        }
        if (CallToDeprecatedMethodCheck.isDeprecatedMethod(tree) || CallToDeprecatedMethodCheck.isDeprecatedClassTree(tree)) {
            ++this.nestedDeprecationLevel;
        }
    }

    public void leaveNode(Tree tree) {
        if (CallToDeprecatedMethodCheck.isDeprecatedMethod(tree) || CallToDeprecatedMethodCheck.isDeprecatedClassTree(tree)) {
            --this.nestedDeprecationLevel;
        }
    }

    private void checkIdentifierIssue(IdentifierTree identifierTree) {
        if (CallToDeprecatedMethodCheck.isSimpleNameOfVariableTreeOrVariableIsDeprecated(identifierTree)) {
            return;
        }
        Symbol symbol = identifierTree.symbol();
        if (CallToDeprecatedMethodCheck.isDeprecated(symbol)) {
            String name = CallToDeprecatedMethodCheck.isConstructor(symbol) ? symbol.owner().name() : symbol.name();
            this.reportIssue((Tree)identifierTree, "Remove this use of \"" + name + "\"; it is deprecated.");
        }
    }

    private static boolean isSimpleNameOfVariableTreeOrVariableIsDeprecated(IdentifierTree identifierTree) {
        Tree parent = identifierTree.parent();
        return parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (identifierTree.equals(((VariableTree)parent).simpleName()) || ((VariableTree)parent).symbol().isDeprecated());
    }

    private void checkMethodIssue(MethodTree methodTree) {
        if (!methodTree.symbol().isDeprecated() && CallToDeprecatedMethodCheck.isOverridingDeprecatedConcreteMethod((JavaSymbol.MethodJavaSymbol)methodTree.symbol())) {
            this.reportIssue((Tree)methodTree.simpleName(), "Don't override a deprecated method or explicitly mark it as \"@Deprecated\".");
        }
    }

    private static boolean isDeprecated(Symbol symbol) {
        return symbol.isDeprecated() || CallToDeprecatedMethodCheck.isConstructor(symbol) && symbol.owner().isDeprecated() || CallToDeprecatedMethodCheck.isDeprecatedEnumConstant(symbol);
    }

    private static boolean isDeprecatedEnumConstant(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.isEnum() && symbol.type().symbol().isDeprecated();
    }

    private static boolean isConstructor(Symbol symbol) {
        return symbol.isMethodSymbol() && "<init>".equals(symbol.name());
    }

    private static boolean isOverridingDeprecatedConcreteMethod(JavaSymbol.MethodJavaSymbol symbol) {
        for (JavaSymbol.MethodJavaSymbol overriddenMethod = symbol.overriddenSymbol(); overriddenMethod != null && !overriddenMethod.isUnknown(); overriddenMethod = overriddenMethod.overriddenSymbol()) {
            if (overriddenMethod.isAbstract()) {
                return false;
            }
            if (!overriddenMethod.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeprecatedMethod(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}) && ((MethodTree)tree).symbol().isDeprecated();
    }

    private static boolean isDeprecatedClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE}) && ((ClassTree)tree).symbol().isDeprecated();
    }
}

