/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.beust.jcommander.JCommander;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.internal.cli.StandaloneCliOptions;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.selenium.node.ChromeMutator;
import org.openqa.grid.selenium.node.FirefoxMutator;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.grid.web.servlet.DisplayHelpHandler;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.server.BaseServer;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.DefaultPipeline;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.WebDriverServlet;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedService;

@ManagedService(objectName="org.seleniumhq.server:type=SeleniumServer")
public class SeleniumServer
extends BaseServer
implements GridNodeServer {
    private static final Logger LOG = Logger.getLogger(SeleniumServer.class.getName());
    private final StandaloneConfiguration configuration;
    private Map<String, Class<? extends Servlet>> extraServlets;
    private ObjectName objectName;
    private ActiveSessions allSessions;

    public SeleniumServer(StandaloneConfiguration configuration) {
        super(new BaseServerOptions((Config)new AnnotatedConfig((Object)configuration)));
        this.configuration = configuration;
        this.objectName = new JMXHelper().register((Object)this).getObjectName();
    }

    @Override
    public int getRealPort() {
        if (this.isStarted()) {
            return this.getUrl().getPort();
        }
        return this.configuration.port;
    }

    private void addRcSupport() {
        try {
            Class<Servlet> rcServlet = Class.forName("com.thoughtworks.selenium.webdriven.WebDriverBackedSeleniumServlet", false, this.getClass().getClassLoader()).asSubclass(Servlet.class);
            this.addServlet(rcServlet, "/selenium-server/driver/");
            LOG.info("Bound legacy RC support");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void addExtraServlets() {
        if (this.extraServlets != null && this.extraServlets.size() > 0) {
            for (String path : this.extraServlets.keySet()) {
                if ("/*".equals(path) && DisplayHelpServlet.class.equals(this.extraServlets.get(path))) continue;
                this.addServlet(this.extraServlets.get(path), path);
            }
        }
    }

    @Override
    public void setExtraServlets(Map<String, Class<? extends Servlet>> extraServlets) {
        this.extraServlets = extraServlets;
    }

    @Override
    public boolean boot() {
        long inactiveSessionTimeoutSeconds = this.configuration.timeout == null ? 9223372036854775L : (long)this.configuration.timeout.intValue();
        NewSessionPipeline pipeline = this.createPipeline(this.configuration);
        this.allSessions = new ActiveSessions(inactiveSessionTimeoutSeconds, TimeUnit.SECONDS);
        WebDriverServlet driverServlet = new WebDriverServlet(this.allSessions, pipeline);
        this.addServlet((Servlet)driverServlet, "/wd/hub/*");
        this.addServlet((Servlet)driverServlet, "/webdriver/*");
        this.addRoute((Route)Routes.matching(req -> true).using((CommandHandler)new DisplayHelpHandler(new Json(), GridRole.get(this.configuration.role), "/wd/hub")));
        this.addRcSupport();
        this.addExtraServlets();
        this.start();
        LOG.info(String.format("Selenium Server is up and running on port %s", this.configuration.port));
        return true;
    }

    private NewSessionPipeline createPipeline(StandaloneConfiguration configuration) {
        NewSessionPipeline.Builder builder = DefaultPipeline.createDefaultPipeline();
        if (configuration instanceof GridNodeConfiguration) {
            ((GridNodeConfiguration)configuration).capabilities.forEach(caps -> {
                builder.addCapabilitiesMutator(new ChromeMutator((Capabilities)caps));
                builder.addCapabilitiesMutator(new FirefoxMutator((Capabilities)caps));
                builder.addCapabilitiesMutator(c -> new ImmutableCapabilities(c.asMap().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("server:")).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
            });
        }
        return builder.create();
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            new JMXHelper().unregister(this.objectName);
            this.stopAllBrowsers();
        }
    }

    private void stopAllBrowsers() {
        if (this.allSessions == null) {
            return;
        }
        this.allSessions.getAllSessions().parallelStream().forEach(session -> {
            try {
                session.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void main(String[] args) {
        StandaloneCliOptions options = new StandaloneCliOptions();
        JCommander.newBuilder().addObject((Object)options).build().parse(args);
        if (options.getCommonOptions().getHelp().booleanValue()) {
            StringBuilder message = new StringBuilder();
            new JCommander((Object)options).usage(message);
            System.err.println(message.toString());
            return;
        }
        SeleniumServer server = new SeleniumServer(new StandaloneConfiguration(options));
        server.boot();
    }
}

