/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.cli.GridHubCliOptions;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.internal.utils.configuration.json.HubJsonConfiguration;
import org.openqa.selenium.json.JsonInput;

public class GridHubConfiguration
extends GridConfiguration {
    public static final String DEFAULT_HUB_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultHub.json";
    private static HubJsonConfiguration DEFAULT_CONFIG_FROM_JSON = HubJsonConfiguration.loadFromResourceOrFile("org/openqa/grid/common/defaults/DefaultHub.json");
    @VisibleForTesting
    static final String ROLE = "hub";
    public String hubConfig;
    public CapabilityMatcher capabilityMatcher;
    public Integer newSessionWaitTimeout;
    public Prioritizer prioritizer;
    public Boolean throwOnCapabilityNotPresent;
    public String registry;
    private String[] rawArgs;
    private String configFile;

    public GridHubConfiguration() {
        this(DEFAULT_CONFIG_FROM_JSON);
    }

    public GridHubConfiguration(HubJsonConfiguration jsonConfig) {
        super(jsonConfig);
        this.role = ROLE;
        this.cleanUpCycle = Optional.ofNullable(jsonConfig.getCleanUpCycle()).orElse(DEFAULT_CONFIG_FROM_JSON.getCleanUpCycle());
        this.newSessionWaitTimeout = Optional.ofNullable(jsonConfig.getNewSessionWaitTimeout()).orElse(DEFAULT_CONFIG_FROM_JSON.getNewSessionWaitTimeout());
        this.throwOnCapabilityNotPresent = Optional.ofNullable(jsonConfig.getThrowOnCapabilityNotPresent()).orElse(DEFAULT_CONFIG_FROM_JSON.getThrowOnCapabilityNotPresent());
        this.registry = Optional.ofNullable(jsonConfig.getRegistry()).orElse(DEFAULT_CONFIG_FROM_JSON.getRegistry());
        this.capabilityMatcher = Optional.ofNullable(jsonConfig.getCapabilityMatcher()).orElse(DEFAULT_CONFIG_FROM_JSON.getCapabilityMatcher());
        this.prioritizer = Optional.ofNullable(jsonConfig.getPrioritizer()).orElse(DEFAULT_CONFIG_FROM_JSON.getPrioritizer());
    }

    public GridHubConfiguration(GridHubCliOptions hubOptions) {
        this(Optional.ofNullable(hubOptions.getConfigFile()).map(HubJsonConfiguration::loadFromResourceOrFile).orElse(DEFAULT_CONFIG_FROM_JSON));
        super.merge(hubOptions.getCommonGridOptions());
        this.configFile = hubOptions.getConfigFile();
        Optional.ofNullable(hubOptions.getNewSessionWaitTimeout()).ifPresent(v -> {
            this.newSessionWaitTimeout = v;
        });
        Optional.ofNullable(hubOptions.getThrowOnCapabilityNotPresent()).ifPresent(v -> {
            this.throwOnCapabilityNotPresent = v;
        });
        Optional.ofNullable(hubOptions.getRegistry()).ifPresent(v -> {
            this.registry = v;
        });
        Optional.ofNullable(hubOptions.getCapabilityMatcher()).ifPresent(v -> {
            this.capabilityMatcher = v;
        });
        Optional.ofNullable(hubOptions.getPrioritizer()).ifPresent(v -> {
            this.prioritizer = v;
        });
    }

    public static GridHubConfiguration loadFromJSON(String filePath) {
        return GridHubConfiguration.loadFromJSON(StandaloneConfiguration.loadJsonFromResourceOrFile(filePath));
    }

    public static GridHubConfiguration loadFromJSON(JsonInput jsonInput) {
        try {
            GridHubConfiguration fromJson = new GridHubConfiguration(HubJsonConfiguration.loadFromJson(jsonInput));
            GridHubConfiguration result = new GridHubConfiguration();
            result.merge(fromJson);
            if (fromJson.host != null) {
                result.host = fromJson.host;
            }
            if (fromJson.port != null) {
                result.port = fromJson.port;
            }
            return result;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void merge(GridHubConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(CapabilityMatcher.class, other.capabilityMatcher, this.capabilityMatcher)) {
            this.capabilityMatcher = other.capabilityMatcher;
        }
        if (this.isMergeAble(Integer.class, other.newSessionWaitTimeout, this.newSessionWaitTimeout)) {
            this.newSessionWaitTimeout = other.newSessionWaitTimeout;
        }
        if (this.isMergeAble(Prioritizer.class, other.prioritizer, this.prioritizer)) {
            this.prioritizer = other.prioritizer;
        }
        if (this.isMergeAble(Boolean.class, other.throwOnCapabilityNotPresent, this.throwOnCapabilityNotPresent)) {
            this.throwOnCapabilityNotPresent = other.throwOnCapabilityNotPresent;
        }
        if (this.isMergeAble(String.class, other.registry, this.registry)) {
            this.registry = other.registry;
        }
    }

    @Override
    protected void serializeFields(Map<String, Object> appendTo) {
        super.serializeFields(appendTo);
        appendTo.put("capabilityMatcher", this.capabilityMatcher.getClass().getName());
        appendTo.put("newSessionWaitTimeout", this.newSessionWaitTimeout);
        appendTo.put("prioritizer", this.prioritizer == null ? null : this.prioritizer.getClass().getName());
        appendTo.put("throwOnCapabilityNotPresent", this.throwOnCapabilityNotPresent);
        appendTo.put("registry", this.registry);
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "hubConfig", this.hubConfig));
        sb.append((CharSequence)this.toString(format, "capabilityMatcher", this.capabilityMatcher.getClass().getCanonicalName()));
        sb.append((CharSequence)this.toString(format, "newSessionWaitTimeout", this.newSessionWaitTimeout));
        sb.append((CharSequence)this.toString(format, "prioritizer", this.prioritizer != null ? this.prioritizer.getClass().getCanonicalName() : null));
        sb.append((CharSequence)this.toString(format, "throwOnCapabilityNotPresent", this.throwOnCapabilityNotPresent));
        sb.append((CharSequence)this.toString(format, "registry", this.registry));
        return sb.toString();
    }

    public void setRawArgs(String[] rawArgs) {
        this.rawArgs = rawArgs;
    }

    public String[] getRawArgs() {
        return this.rawArgs;
    }

    public String getConfigFile() {
        return this.configFile;
    }
}

