/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v100;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v100.target.Target;
import org.openqa.selenium.devtools.v100.target.model.SessionID;
import org.openqa.selenium.devtools.v100.target.model.TargetID;
import org.openqa.selenium.devtools.v100.target.model.TargetInfo;
import org.openqa.selenium.json.TypeToken;

public class V100Target
implements org.openqa.selenium.devtools.idealized.target.Target {
    public Command<Void> detachFromTarget(Optional<org.openqa.selenium.devtools.idealized.target.model.SessionID> sessionId, Optional<org.openqa.selenium.devtools.idealized.target.model.TargetID> targetId) {
        return Target.detachFromTarget(sessionId.map(id -> new SessionID(id.toString())), targetId.map(id -> new TargetID(id.toString())));
    }

    public Command<List<org.openqa.selenium.devtools.idealized.target.model.TargetInfo>> getTargets() {
        Function mapper = ConverterFunctions.map((String)"targetInfos", (Type)new TypeToken<List<TargetInfo>>(){}.getType());
        return new Command(Target.getTargets().getMethod(), (Map)ImmutableMap.of(), input -> {
            List infos = (List)mapper.apply(input);
            return (List)infos.stream().map(info -> new org.openqa.selenium.devtools.idealized.target.model.TargetInfo(new org.openqa.selenium.devtools.idealized.target.model.TargetID(info.getTargetId().toString()), info.getType(), info.getTitle(), info.getUrl(), info.getAttached(), info.getOpenerId().map(id -> new org.openqa.selenium.devtools.idealized.target.model.TargetID(id.toString())), info.getBrowserContextId().map(id -> new BrowserContextID(id.toString())))).collect(ImmutableList.toImmutableList());
        });
    }

    public Command<org.openqa.selenium.devtools.idealized.target.model.SessionID> attachToTarget(org.openqa.selenium.devtools.idealized.target.model.TargetID targetId) {
        Function mapper = ConverterFunctions.map((String)"sessionId", SessionID.class);
        return new Command("Target.attachToTarget", (Map)ImmutableMap.of((Object)"targetId", (Object)new TargetID(targetId.toString()), (Object)"flatten", (Object)true), input -> {
            SessionID id = (SessionID)mapper.apply(input);
            return new org.openqa.selenium.devtools.idealized.target.model.SessionID(id.toString());
        });
    }

    public Command<Void> setAutoAttach() {
        return Target.setAutoAttach(true, false, Optional.of(true));
    }

    public Event<org.openqa.selenium.devtools.idealized.target.model.TargetID> detached() {
        return new Event("Target.detachedFromTarget", input -> {
            Function converter = ConverterFunctions.map((String)"targetId", TargetID.class);
            return new org.openqa.selenium.devtools.idealized.target.model.TargetID(((TargetID)converter.apply(input)).toString());
        });
    }
}

