/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0002\t\u00055i\u0015PU;o\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u000b\u0019\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003\u001d\t1a\u001c:h'\r\u0001\u0011B\u0005\t\u0003\u0015Ai\u0011a\u0003\u0006\u0003\u00195\tAB\\8uS\u001aL7-\u0019;j_:T!AD\b\u0002\rI,hN\\3s\u0015\t\u0019a!\u0003\u0002\u0012\u0017\tY!+\u001e8MSN$XM\\3s!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011e\u0001!\u0011!Q\u0001\nm\taA]3q_J$8\u0001\u0001\t\u00039ui\u0011\u0001B\u0005\u0003=\u0011\u0011\u0001BU3q_J$XM\u001d\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u000511m\u001c8gS\u001e\u0004BAI\u0013)W9\u00111cI\u0005\u0003IQ\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\ri\u0015\r\u001d\u0006\u0003IQ\u0001\"AI\u0015\n\u0005):#AB*ue&tw\r\u0005\u0002\u0014Y%\u0011Q\u0006\u0006\u0002\u0004\u0003:L\b\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0015QDW\r\u0016:bG.,'\u000f\u0005\u0002\u001dc%\u0011!\u0007\u0002\u0002\b)J\f7m[3s\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q!a\u0007O\u001d;!\t9\u0004!D\u0001\u0003\u0011\u0015I2\u00071\u0001\u001c\u0011\u0015\u00013\u00071\u0001\"\u0011\u0015y3\u00071\u00011\u0011\u001da\u0004A1A\u0005\u0002u\n1BZ1jY\u0016$G+Z:ugV\ta\bE\u0002@\t\"j\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA!\u001e;jY*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\r\u0019V\r\u001e\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002 \u0002\u0019\u0019\f\u0017\u000e\\3e)\u0016\u001cHo\u001d\u0011\t\u000b%\u0003A\u0011\t&\u0002\u0017Q,7\u000f\u001e$bS2,(/\u001a\u000b\u0003\u0017:\u0003\"a\u0005'\n\u00055#\"\u0001B+oSRDQa\u0014%A\u0002A\u000bqAZ1jYV\u0014X\r\u0005\u0002\u000b#&\u0011!k\u0003\u0002\b\r\u0006LG.\u001e:f\u0011\u0015!\u0006\u0001\"\u0011V\u00031!Xm\u001d;GS:L7\u000f[3e)\tYe\u000bC\u0003X'\u0002\u0007\u0001,A\u0006eKN\u001c'/\u001b9uS>t\u0007CA-[\u001b\u0005i\u0011BA.\u000e\u0005-!Um]2sSB$\u0018n\u001c8\t\u000bu\u0003A\u0011\t0\u0002\u0017Q,7\u000f^%h]>\u0014X\r\u001a\u000b\u0003\u0017~CQa\u0016/A\u0002aCQ!\u0019\u0001\u0005B\t\fq\u0002^3tiJ+hNR5oSNDW\r\u001a\u000b\u0003\u0017\u000eDQ\u0001\u001a1A\u0002\u0015\faA]3tk2$\bCA-g\u0013\t9WB\u0001\u0004SKN,H\u000e\u001e\u0005\u0006S\u0002!\tE[\u0001\u000fi\u0016\u001cHOU;o'R\f'\u000f^3e)\tY5\u000eC\u0003XQ\u0002\u0007\u0001\fC\u0003n\u0001\u0011\u0005c.A\u0006uKN$8\u000b^1si\u0016$GCA&p\u0011\u00159F\u000e1\u0001Y\u0011\u001d\t\bA1A\u0005\u0002I\f\u0001\u0004V#T)~#UiU\"S\u0013B#\u0016j\u0014(`!\u0006#F+\u0012*O+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<A\u0003\u0015\u0011XmZ3y\u0013\tAXOA\u0004QCR$XM\u001d8\t\ri\u0004\u0001\u0015!\u0003t\u0003e!Vi\u0015+`\t\u0016\u001b6IU%Q)&{ej\u0018)B)R+%K\u0014\u0011\t\u000bq\u0004A\u0011B?\u0002)A\f'o]3UKN$H)Z:de&\u0004H/[8o)\rq\u00181\u0001\t\u0006'}D\u0003\u0006K\u0005\u0004\u0003\u0003!\"A\u0002+va2,7\u0007C\u0003Xw\u0002\u0007\u0001\f")
public class MyRunListener
extends RunListener
implements ScalaObject {
    private final Reporter report;
    private final Tracker theTracker;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public void testFailure(Failure failure) {
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
        String testName = (String)tuple32._1();
        String testClass = (String)tuple32._2();
        String testClassName = (String)tuple32._3();
        Throwable throwableOrNull = failure.getException();
        None$ throwable = throwableOrNull == null ? None$.MODULE$ : new Some((Object)throwableOrNull);
        String message = throwableOrNull == null ? Resources$.MODULE$.apply("jUnitTestFailed") : throwableOrNull.toString();
        IndentedText formatter = Suite$.MODULE$.getIndentedText(testName, 1, true);
        this.report.apply(TestFailed$.MODULE$.apply(this.theTracker.nextOrdinal(), message, testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Throwable>)throwable, (Option<Long>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
    }

    public void testFinished(Description description) {
        if (!this.failedTests().contains(description.getDisplayName())) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            IndentedText formatter = Suite$.MODULE$.getIndentedText(testName, 1, true);
            this.report.apply(TestSucceeded$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Long>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
        }
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
        String testName = (String)tuple32._1();
        String testClass = (String)tuple32._2();
        String testClassName = (String)tuple32._3();
        String testSucceededIcon = Resources$.MODULE$.apply("testSucceededIconChar");
        String formattedText = Resources$.MODULE$.apply("iconPlusShortName", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{testSucceededIcon, testName}));
        this.report.apply(TestIgnored$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Formatter>)new Some((Object)new IndentedText(formattedText, testName, 1))));
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
        String testName = (String)tuple32._1();
        String testClass = (String)tuple32._2();
        String testClassName = (String)tuple32._3();
        this.report.apply(TestStarting$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Rerunner>)None$.MODULE$));
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (matcher.find()) {
            String testName = matcher.group(1);
            String testClass = matcher.group(2);
            String testClassName = testClass.replaceAll(".*\\.", "");
            return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"unexpected displayName [").append((Object)description.getDisplayName()).append((Object)"]").toString());
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker) {
        this.report = report;
        this.theTracker = theTracker;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

